/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.comment;

import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.comment.Comment;
import com.atlassian.bamboo.comment.CommentDao;
import com.atlassian.bamboo.comment.CommentImpl;
import com.atlassian.bamboo.comment.CommentManager;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.user.User;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommentManagerImpl
implements CommentManager {
    private static final Logger log = Logger.getLogger(CommentManagerImpl.class);
    private final CommentDao commentDao;
    private final LoadingCache<Long, Integer> commitCountCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Long, Integer>(){

        public Integer load(Long id) throws Exception {
            return CommentManagerImpl.this.getCommentsForEntity(id).size();
        }
    });

    public CommentManagerImpl(CommentDao commentDao) {
        this.commentDao = commentDao;
    }

    @NotNull
    public Comment addComment(String content, User user, long entityId) {
        CommentImpl comment = new CommentImpl(content, user.getName(), new Date(), entityId);
        this.commentDao.save((BambooObject)comment);
        return comment;
    }

    public void deleteComment(@NotNull Comment comment) {
        this.commentDao.delete((BambooObject)comment);
    }

    public void deleteAllCommentsForEntity(@NotNull BambooIdProvider entity) {
        this.commentDao.deleteAll((Collection)this.commentDao.getCommentsForEntity(entity.getId()));
    }

    @Nullable
    public Comment getCommentById(long commentId) {
        return this.commentDao.findById(commentId);
    }

    @NotNull
    public List<Comment> getCommentsForEntity(long entityId) {
        return this.commentDao.getCommentsForEntity(entityId);
    }

    @NotNull
    public Integer getEntityCommentCount(long id) {
        return this.getEntityCommentCountNoTx(id);
    }

    @NotNull
    public Integer getEntityCommentCountNoTx(long id) {
        return (Integer)this.commitCountCache.getUnchecked((Object)id);
    }

    public void saveComment(Comment comment) {
        this.commentDao.save((BambooObject)comment);
    }

    @NotNull
    public List<Comment> getCommentsForBuildResults(@NotNull PlanKey planKey) {
        return this.commentDao.getCommentsForBuildResults(planKey);
    }

    @NotNull
    public Map<Long, List<Comment>> getCommentsForJobResults(@NotNull ChainResultsSummary chainResultSummary) {
        List commentsForChainResult = this.commentDao.getCommentsForJobResults(chainResultSummary);
        HashMap<Long, List<Comment>> mappedFromEntityId = new HashMap<Long, List<Comment>>();
        for (Comment comment : commentsForChainResult) {
            long entityId = comment.getEntityId();
            List commentsForEntity = mappedFromEntityId.computeIfAbsent(entityId, k -> new LinkedList());
            commentsForEntity.add(comment);
        }
        return mappedFromEntityId;
    }

    public void onCommentForEntityChanged(long entityId) {
        this.commitCountCache.invalidate((Object)entityId);
    }
}

