/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.comment;

import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.comment.Comment;
import com.atlassian.bamboo.comment.CommentManager;
import com.atlassian.bamboo.comment.CommentService;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.event.BuildCommentDeletedEvent;
import com.atlassian.bamboo.event.BuildCommentedEvent;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueUtils;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.user.User;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommentServiceImpl
implements CommentService {
    private final CommentManager commentManager;
    private final JiraIssueUtils jiraIssueUtils;
    private final EventPublisher eventPublisher;

    public CommentServiceImpl(CommentManager commentManager, JiraIssueUtils jiraIssueUtils, EventPublisher eventPublisher) {
        this.commentManager = commentManager;
        this.jiraIssueUtils = jiraIssueUtils;
        this.eventPublisher = eventPublisher;
    }

    @Nullable
    public Comment getCommentById(long commentId) {
        return this.commentManager.getCommentById(commentId);
    }

    @NotNull
    public List<Comment> getCommentsForEntity(long entityId) {
        return this.commentManager.getCommentsForEntity(entityId);
    }

    @NotNull
    public List<Comment> getCommentsForEntity(BambooIdProvider entity) {
        return this.commentManager.getCommentsForEntity(entity.getId());
    }

    @NotNull
    public Map<Long, List<Comment>> getAllCommentsForPlanResult(@NotNull ChainResultsSummary chainResultSummary) {
        HashMap<Long, List<Comment>> allCommentsForPlanResult = new HashMap<Long, List<Comment>>();
        List commentsForEntity = this.commentManager.getCommentsForEntity(chainResultSummary.getId());
        if (!commentsForEntity.isEmpty()) {
            allCommentsForPlanResult.put(chainResultSummary.getId(), commentsForEntity);
        }
        allCommentsForPlanResult.putAll(this.commentManager.getCommentsForJobResults(chainResultSummary));
        return allCommentsForPlanResult;
    }

    public Comment addComment(@NotNull String content, @NotNull User user, BambooIdProvider entity) {
        Comment comment = this.commentManager.addComment(content, user, entity.getId());
        ResultsSummary resultsSummary = (ResultsSummary)Narrow.downTo((Object)entity, ResultsSummary.class);
        if (resultsSummary != null) {
            this.eventPublisher.publish((Object)new BuildCommentedEvent(this, resultsSummary.getPlanResultKey(), comment));
            this.jiraIssueUtils.findAndSaveJiraIssueKeys(content, resultsSummary);
        }
        return comment;
    }

    public void deleteComment(@NotNull Comment comment, @NotNull ResultsSummary resultsSummary) {
        this.commentManager.deleteComment(comment);
        this.eventPublisher.publish((Object)new BuildCommentDeletedEvent(this, resultsSummary.getPlanResultKey(), comment));
    }

    public void deleteComment(@NotNull Comment comment) {
        this.commentManager.deleteComment(comment);
    }
}

