/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.commit;

import com.atlassian.bamboo.author.AuthorContext;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class AuthorContextImpl
implements AuthorContext {
    private final String name;
    private final String linkedUserName;
    private final String email;

    public AuthorContextImpl(@NotNull AuthorContext author) {
        this(author.getName(), author.getLinkedUserName(), author.getEmail());
    }

    public AuthorContextImpl(String author) {
        this(author, null, null);
    }

    public AuthorContextImpl(String author, String linkedUserName, String email) {
        this.name = author;
        this.linkedUserName = linkedUserName;
        this.email = email;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getEmail() {
        return this.email;
    }

    @Nullable
    public String getLinkedUserName() {
        return this.linkedUserName;
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }

    public boolean equals(Object o) {
        if (!(o instanceof AuthorContext)) {
            return false;
        }
        AuthorContext rhs = (AuthorContext)o;
        return new EqualsBuilder().append((Object)this.getName(), (Object)rhs.getName()).isEquals();
    }

    public int compareTo(AuthorContext otherAuthor) {
        return new CompareToBuilder().append((Object)this.getName(), (Object)otherAuthor.getName()).toComparison();
    }
}

