/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.commit;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.author.AuthorContext;
import com.atlassian.bamboo.collections.message.FinalArrayList;
import com.atlassian.bamboo.commit.AuthorContextImpl;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.commit.CommitFile;
import com.atlassian.bamboo.commit.CommitFileImpl;
import com.atlassian.bamboo.util.BuildUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitContextImpl
implements CommitContext,
Serializable {
    private static final Logger log = Logger.getLogger(CommitContextImpl.class);
    private final AuthorContextImpl author;
    private final FinalArrayList<CommitFile> files;
    private String branch;
    private final String comment;
    private final Date date;
    private final String changeSetId;
    private final boolean foreignCommit;

    public CommitContextImpl(AuthorContext author, @NotNull List<CommitFile> files, @NotNull String comment, @NotNull Date date, String changeSetId) {
        this(author, files, comment, date, changeSetId, null, false);
    }

    private CommitContextImpl(Author author, @NotNull List<CommitFile> files, @NotNull String comment, @NotNull Date date, String changeSetId, String branch, boolean foreignCommit) {
        this.author = new AuthorContextImpl((AuthorContext)author);
        this.files = new FinalArrayList(files);
        this.comment = comment;
        this.date = date;
        this.changeSetId = changeSetId;
        this.branch = branch;
        this.foreignCommit = foreignCommit;
    }

    private CommitContextImpl(@Nullable AuthorContext author, @NotNull List<CommitFile> files, @NotNull String comment, @NotNull Date date, String changeSetId, String branch, boolean foreignCommit) {
        this.author = author == null ? null : new AuthorContextImpl(author);
        this.files = new FinalArrayList(files);
        this.comment = comment;
        this.date = date;
        this.changeSetId = changeSetId;
        this.branch = branch;
        this.foreignCommit = foreignCommit;
    }

    CommitContextImpl(CommitContext commitContext, boolean foreignCommit) {
        this(commitContext.getAuthorContext(), (List<CommitFile>)commitContext.getFiles(), commitContext.getComment(), commitContext.getDate(), commitContext.getChangeSetId(), commitContext instanceof CommitContextImpl ? ((CommitContextImpl)commitContext).getBranch() : null, foreignCommit);
    }

    public AuthorContext getAuthorContext() {
        return this.author;
    }

    @NotNull
    public List<CommitFile> getFiles() {
        return this.files;
    }

    @NotNull
    public String getComment() {
        return this.comment;
    }

    @NotNull
    public Date getDate() {
        return this.date;
    }

    @Nullable
    public String getBranch() {
        return this.branch;
    }

    public String getChangeSetId() {
        return this.changeSetId;
    }

    public boolean isForeignCommit() {
        return this.foreignCommit;
    }

    @Nullable
    public String guessChangeSetId() {
        if (StringUtils.isNotBlank((CharSequence)this.changeSetId)) {
            return this.changeSetId;
        }
        if (this.files != null) {
            String candidateCS = null;
            for (CommitFile file : this.files) {
                String revision = file.getRevision();
                if (candidateCS == null) {
                    candidateCS = revision;
                    continue;
                }
                if (candidateCS.equals(revision)) continue;
                return null;
            }
            return candidateCS;
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        return new HashCodeBuilder(1061, 7).append((Object)this.getAuthorContext()).append((Object)this.getComment()).append(this.getDate() == null ? 0L : this.getDate().getTime()).append((Object)this.getChangeSetId()).append(this.isForeignCommit()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof CommitContextImpl)) {
            return false;
        }
        CommitContextImpl rhs = (CommitContextImpl)o;
        return new EqualsBuilder().append((Object)this.getAuthorContext(), (Object)rhs.getAuthorContext()).append((Object)this.getComment(), (Object)rhs.getComment()).append(this.getDate() == null ? 0L : this.getDate().getTime(), rhs.getDate() == null ? 0L : rhs.getDate().getTime()).append((Object)this.getChangeSetId(), (Object)rhs.getChangeSetId()).append(this.isForeignCommit(), rhs.isForeignCommit()).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("date", (Object)this.date).append("revision", (Object)this.changeSetId).append("author", (Object)this.author).append("comment", (Object)this.comment).toString();
    }

    public static class Builder {
        private AuthorContext author;
        private String changesetId;
        private String comment;
        private Date date;
        private List<CommitFile> files = new ArrayList<CommitFile>();
        private String branch;
        private static final Date NON_NULL_DATE = new Date(0L);
        private boolean foreignCommit;

        public CommitContextImpl build() {
            Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)this.changesetId), (Object)"Changeset id is missing from the commit context");
            String nonNullComment = (String)MoreObjects.firstNonNull((Object)this.comment, (Object)"");
            Date nonNullDate = (Date)MoreObjects.firstNonNull((Object)this.date, (Object)NON_NULL_DATE);
            return new CommitContextImpl(this.author, this.files, nonNullComment, nonNullDate, this.changesetId, this.branch, this.foreignCommit);
        }

        public Builder author(@NotNull String author, @NotNull String email) {
            if (BuildUtils.isDevMode()) {
                Preconditions.checkArgument((boolean)author.equals(author.trim()), (Object)"Author should have been trimmed by repository");
            }
            author = this.normaliseAuthorName(author);
            return this.author(new AuthorContextImpl(author, null, email.trim()));
        }

        public Builder author(@Nullable String author) {
            if (BuildUtils.isDevMode() && author != null) {
                Preconditions.checkArgument((boolean)author.equals(author.trim()), (Object)"Author should have been trimmed by repository");
            }
            author = this.normaliseAuthorName(author);
            return this.author(new AuthorContextImpl(author));
        }

        private String normaliseAuthorName(@Nullable String authorName) {
            if (StringUtils.isBlank((CharSequence)authorName)) {
                return "[unknown]";
            }
            assert (authorName != null);
            return authorName.trim();
        }

        public Builder author(@NotNull AuthorContext author) {
            this.author = author;
            return this;
        }

        public Builder changesetId(String changesetId) {
            this.changesetId = changesetId;
            return this;
        }

        public Builder comment(@Nullable String comment) {
            this.comment = comment;
            return this;
        }

        public Builder date(@Nullable Date date) {
            this.date = date;
            return this;
        }

        public Builder file(CommitFile file) {
            this.files.add(file);
            return this;
        }

        @Deprecated
        public Builder file(String revision, String name) {
            return this.file(new CommitFileImpl(revision, name));
        }

        public Builder file(String revision, String name, String commitRevision) {
            return this.file(new CommitFileImpl(revision, name, commitRevision));
        }

        public Builder files(Iterable<CommitFile> files) {
            Iterables.addAll(this.files, files);
            return this;
        }

        public Builder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public Builder foreignCommit(boolean foreignCommit) {
            this.foreignCommit = foreignCommit;
            return this;
        }
    }
}

