/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.commit;

import com.atlassian.bamboo.commit.CommitFile;
import java.io.Serializable;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitFileImpl
implements CommitFile,
Serializable,
Comparable<CommitFileImpl> {
    private static final Logger log = Logger.getLogger(CommitFileImpl.class);
    private String name;
    private String revision;
    private String changesetId;

    public CommitFileImpl() {
    }

    public CommitFileImpl(String name) {
        this.name = name;
    }

    @Deprecated
    public CommitFileImpl(String revision, String name) {
        this.revision = revision;
        this.name = name;
    }

    public CommitFileImpl(String revision, String name, String changesetId) {
        this.revision = revision;
        this.name = name;
        this.changesetId = changesetId;
    }

    public String getName() {
        return this.name;
    }

    public String getCleanName() {
        String cleanName = this.name;
        cleanName = cleanName.replaceAll("/Attic/", "/");
        return cleanName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public boolean isRevisionKnown() {
        return !"Unknown".equalsIgnoreCase(this.getRevision());
    }

    @NotNull
    public CommitFile cloneCommitFile() {
        return new CommitFileImpl(this.revision, this.name, this.changesetId);
    }

    @Nullable
    public String getChangesetId() {
        return this.changesetId;
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 173).append((Object)this.getName()).append((Object)this.getRevision()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof CommitFileImpl)) {
            return false;
        }
        CommitFileImpl rhs = (CommitFileImpl)o;
        return new EqualsBuilder().append((Object)this.getName(), (Object)rhs.getName()).append((Object)this.getRevision(), (Object)rhs.getRevision()).isEquals();
    }

    @Override
    public int compareTo(CommitFileImpl obj) {
        CommitFileImpl o = obj;
        return new CompareToBuilder().append((Object)this.getName(), (Object)o.getName()).append((Object)this.getRevision(), (Object)o.getRevision()).toComparison();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.getName()).append("revision", (Object)this.getRevision()).toString();
    }
}

