/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.commit;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.author.AuthorContext;
import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.commit.CommitFile;
import com.atlassian.bamboo.commit.CommitFileImpl;
import com.atlassian.bamboo.core.BambooEntityObject;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangeset;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="USER_COMMIT")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class CommitImpl
extends BambooEntityObject
implements Commit {
    private static final Logger log = Logger.getLogger(CommitImpl.class);
    private Author author;
    private Set<CommitFile> files = new HashSet<CommitFile>();
    private String comment;
    private Date date;
    private String changeSetId;
    private boolean foreignCommit;
    @Nullable
    private RepositoryChangeset repositoryChangeset;

    public Author getAuthor() {
        return this.author;
    }

    public AuthorContext getAuthorContext() {
        return this.author;
    }

    public void setAuthor(Author author) {
        this.author = author;
    }

    public void addFile(CommitFile commitFile) {
        this.files.add(commitFile);
    }

    @NotNull
    public List<CommitFile> getFiles() {
        return this.files.stream().map(f -> new CommitFileImpl(f.getRevision(), f.getName(), this.changeSetId)).sorted().collect(Collectors.toList());
    }

    public void setFiles(List<CommitFile> files) {
        this.files = new HashSet<CommitFile>(files);
    }

    @NotNull
    public String getComment() {
        if (this.comment != null) {
            return this.comment;
        }
        return "";
    }

    @Nullable
    public String guessChangeSetId() {
        if (StringUtils.isNotBlank((CharSequence)this.changeSetId)) {
            return this.changeSetId;
        }
        if (this.files != null) {
            String candidateCS = null;
            for (CommitFile file : this.files) {
                String revision = file.getRevision();
                if (candidateCS == null) {
                    candidateCS = revision;
                    continue;
                }
                if (candidateCS.equals(revision)) continue;
                return null;
            }
            return candidateCS;
        }
        return null;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getChangeSetId() {
        return this.changeSetId;
    }

    public void setChangeSetId(String changeSetId) {
        this.changeSetId = changeSetId;
    }

    @NotNull
    public Date getDate() {
        return this.date;
    }

    public void setDate(@NotNull Date date) {
        this.date = date;
    }

    @Nullable
    public RepositoryChangeset getRepositoryChangeset() {
        return this.repositoryChangeset;
    }

    public void setRepositoryChangeset(@Nullable RepositoryChangeset repositoryChangeset) {
        this.repositoryChangeset = repositoryChangeset;
    }

    public boolean isForeignCommit() {
        return this.foreignCommit;
    }

    public void setForeignCommit(boolean foreignCommit) {
        this.foreignCommit = foreignCommit;
    }

    public int hashCode() {
        return new HashCodeBuilder(1061, 7).append((Object)this.getAuthor()).append((Object)this.getComment()).append(this.getDate() == null ? 0L : this.getDate().getTime()).append((Object)this.getChangeSetId()).append((Object)this.getRepositoryChangeset()).append(this.isForeignCommit()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof CommitImpl)) {
            return false;
        }
        CommitImpl rhs = (CommitImpl)((Object)o);
        return new EqualsBuilder().append((Object)this.getAuthor(), (Object)rhs.getAuthor()).append((Object)this.getComment(), (Object)rhs.getComment()).append(this.getDate() == null ? 0L : this.getDate().getTime(), rhs.getDate() == null ? 0L : rhs.getDate().getTime()).append((Object)this.getChangeSetId(), (Object)rhs.getChangeSetId()).append((Object)this.getRepositoryChangeset(), (Object)rhs.getRepositoryChangeset()).append(this.isForeignCommit(), rhs.isForeignCommit()).isEquals();
    }

    public int compareTo(Object obj) {
        CommitImpl o = (CommitImpl)((Object)obj);
        return new CompareToBuilder().append(this.getDate() == null ? 0L : this.getDate().getTime(), o.getDate() == null ? 0L : o.getDate().getTime()).append((Object)this.getAuthor(), (Object)o.getAuthor()).append((Object)this.getComment(), (Object)o.getComment()).append((Object)this.getChangeSetId(), (Object)o.getChangeSetId()).append((Object)this.getRepositoryChangeset(), (Object)o.getRepositoryChangeset()).append(this.isForeignCommit(), o.isForeignCommit()).toComparison();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("date", (Object)this.date).append("revision", (Object)this.changeSetId).append("author", (Object)this.author).append("comment", (Object)this.comment).append("revisionKey", (Object)this.repositoryChangeset).toString();
    }
}

