/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.concurrent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class BambooExecutors {
    private BambooExecutors() {
    }

    public static ExecutorService newBlockingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        BlockingThreadPoolExecutor blockingThreadPoolExecutor = new BlockingThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, (BlockingQueue)workQueue, threadFactory);
        blockingThreadPoolExecutor.allowCoreThreadTimeOut(true);
        return blockingThreadPoolExecutor;
    }

    public static ExecutorService newBlockingThreadPoolExecutor(int poolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        return BambooExecutors.newBlockingThreadPoolExecutor(poolSize, poolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    static class BlockingThreadPoolExecutor
    extends ThreadPoolExecutor {
        private final Semaphore semaphore;

        private BlockingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
            this(new Semaphore(workQueue.remainingCapacity() + workQueue.size()), corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        }

        @VisibleForTesting
        BlockingThreadPoolExecutor(Semaphore semaphore, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
            int permitCount = this.getPermitCount(semaphore);
            int maxQueueSize = workQueue.remainingCapacity() + workQueue.size();
            Preconditions.checkArgument((maxQueueSize > 0 ? 1 : 0) != 0, (Object)"Zero-depth queues are not supported by this executor");
            Preconditions.checkArgument((maxQueueSize == permitCount ? 1 : 0) != 0, (Object)("Mismatch between semaphore permits and work queue depth: " + workQueue.remainingCapacity() + "/" + workQueue.size() + " vs " + permitCount));
            this.semaphore = semaphore;
            try {
                semaphore.acquire(workQueue.size());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Throwables.propagate((Throwable)e);
            }
        }

        private int getPermitCount(Semaphore semaphore) {
            int permitCount = semaphore.drainPermits();
            semaphore.release(permitCount);
            return permitCount;
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            this.semaphore.release();
            super.beforeExecute(t, r);
        }

        @Override
        public void execute(Runnable command) {
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Throwables.propagate((Throwable)e);
            }
            super.execute(command);
        }
    }
}

