/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.concurrent;

import com.atlassian.bamboo.util.BambooObjectUtils;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BlockingSet<E>
implements Set<E> {
    private static final Logger log = Logger.getLogger(BlockingSet.class);
    private final Set<E> delegate = Collections.synchronizedSet(new HashSet());

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Iterator<E> iterator() {
        Set<E> set = this.delegate;
        synchronized (set) {
            return ImmutableSet.copyOf(this.delegate).iterator();
        }
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        try {
            Set<E> set = this.delegate;
            synchronized (set) {
                while (this.delegate.contains(e)) {
                    this.delegate.wait();
                }
                this.delegate.add(e);
                return true;
            }
        }
        catch (InterruptedException ex) {
            log.warn((Object)"", (Throwable)ex);
            throw BambooObjectUtils.asRuntimeException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        Set<E> set = this.delegate;
        synchronized (set) {
            boolean wasPresent = this.delegate.remove(o);
            if (wasPresent) {
                this.delegate.notifyAll();
            }
            return wasPresent;
        }
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> c) {
        for (E e : c) {
            this.add(e);
        }
        return !c.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        Set<E> set = this.delegate;
        synchronized (set) {
            if (this.delegate.retainAll(c)) {
                this.delegate.notifyAll();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        Set<E> set = this.delegate;
        synchronized (set) {
            if (this.delegate.removeAll(c)) {
                this.delegate.notifyAll();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Set<E> set = this.delegate;
        synchronized (set) {
            if (!this.delegate.isEmpty()) {
                this.delegate.notifyAll();
            }
            this.delegate.clear();
        }
    }
}

