/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.concurrent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoundedSet<E>
extends ForwardingSet<E> {
    private final Set<E> delegate;
    private final int maximumSize;

    public BoundedSet(Set<E> delegate, int maximumSize) {
        Preconditions.checkArgument((maximumSize > 0 ? 1 : 0) != 0);
        this.maximumSize = maximumSize;
        this.delegate = Collections.synchronizedSet(delegate);
    }

    public BoundedSet(int maximumSize) {
        this(new HashSet(), maximumSize);
    }

    protected Set<E> delegate() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Iterator<E> iterator() {
        Set<E> set = this.delegate;
        synchronized (set) {
            return ImmutableSet.copyOf(this.delegate).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(E e) {
        Set<E> set = this.delegate;
        synchronized (set) {
            while (this.delegate.size() >= this.maximumSize) {
                this.waitForSpace();
            }
            return this.delegate.add(e);
        }
    }

    @VisibleForTesting
    void waitForSpace() {
        try {
            this.delegate.wait();
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        Set<E> set = this.delegate;
        synchronized (set) {
            boolean setChanged = this.delegate.remove(o);
            if (setChanged) {
                this.delegate.notifyAll();
            }
            return setChanged;
        }
    }

    public boolean addAll(@NotNull Collection<? extends E> c) {
        boolean setChanged = false;
        for (E e : c) {
            setChanged |= this.add(e);
        }
        return setChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(@NotNull Collection<?> c) {
        Set<E> set = this.delegate;
        synchronized (set) {
            boolean setChanged = this.delegate.retainAll(c);
            if (setChanged) {
                this.delegate.notifyAll();
            }
            return setChanged;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(@NotNull Collection<?> c) {
        Set<E> set = this.delegate;
        synchronized (set) {
            boolean setChanged = this.delegate.removeAll(c);
            if (setChanged) {
                this.delegate.notifyAll();
            }
            return setChanged;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Set<E> set = this.delegate;
        synchronized (set) {
            boolean hadContent = !this.delegate.isEmpty();
            this.delegate.clear();
            if (hadContent) {
                this.delegate.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public E poll() {
        Set<E> set = this.delegate;
        synchronized (set) {
            Iterator<E> iterator = this.delegate.iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            E first = iterator.next();
            iterator.remove();
            this.delegate.notifyAll();
            return first;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(E e) {
        Set<E> set = this.delegate;
        synchronized (set) {
            if (this.delegate.size() >= this.maximumSize) {
                return this.delegate.contains(e);
            }
            this.delegate.add(e);
            return true;
        }
    }
}

