/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.concurrent;

import io.atlassian.util.concurrent.BlockingReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public class CalculatingBlockingReference<T> {
    private final Supplier<T> supplier;
    private final ReentrantLock computationLock = new ReentrantLock();
    private final BlockingReference<T> sharedValue = BlockingReference.newMRSW();

    public CalculatingBlockingReference(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() throws InterruptedException {
        boolean calculationInProgress;
        BlockingReference<T> blockingReference = this.sharedValue;
        synchronized (blockingReference) {
            boolean bl = calculationInProgress = !this.computationLock.tryLock();
            if (!calculationInProgress) {
                this.sharedValue.clear();
            }
        }
        if (calculationInProgress) {
            return (T)this.sharedValue.get();
        }
        try {
            T value = this.supplier.get();
            this.sharedValue.set(value);
            T t = value;
            return t;
        }
        finally {
            this.computationLock.unlock();
        }
    }

    public static <T> CalculatingBlockingReference<T> make(Supplier<T> supplier) {
        return new CalculatingBlockingReference<T>(supplier);
    }
}

