/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class CoalescingBlockedCallsReference<T> {
    private final Supplier<T> supplier;
    private final AtomicReference<FutureTask<T>> futureTaskReference = new AtomicReference();

    private CoalescingBlockedCallsReference(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public T get() throws ExecutionException, InterruptedException {
        FutureTask<T> possiblyDoneFutureTask = this.futureTaskReference.get();
        if (possiblyDoneFutureTask == null || possiblyDoneFutureTask.isDone()) {
            return this.getFromNewFutureTask(possiblyDoneFutureTask);
        }
        possiblyDoneFutureTask.get();
        return this.getFromNewFutureTask(possiblyDoneFutureTask);
    }

    private T getFromNewFutureTask(@Nullable FutureTask<T> previousFutureTask) throws InterruptedException, ExecutionException {
        boolean weAreTheOwner = this.futureTaskReference.compareAndSet(previousFutureTask, this.newFutureTask());
        FutureTask<T> futureTask = this.futureTaskReference.get();
        if (weAreTheOwner) {
            futureTask.run();
        }
        return futureTask.get();
    }

    private FutureTask<T> newFutureTask() {
        return new FutureTask(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return CoalescingBlockedCallsReference.this.supplier.get();
            }
        });
    }

    public static <T> CoalescingBlockedCallsReference<T> make(Supplier<T> supplier) {
        return new CoalescingBlockedCallsReference<T>(supplier);
    }

    public static CoalescingBlockedCallsReference<Void> make(final Runnable runnable) {
        return new CoalescingBlockedCallsReference<Void>(new Supplier<Void>(){

            @Override
            public Void get() {
                runnable.run();
                return null;
            }
        });
    }
}

