/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration;

import com.atlassian.bamboo.UnconfigurableFeatureDefaults;
import com.atlassian.bamboo.agent.elastic.server.ElasticConfiguration;
import com.atlassian.bamboo.build.expiry.BuildExpiryConfig;
import com.atlassian.bamboo.build.expiry.ExpiryScheduler;
import com.atlassian.bamboo.build.monitoring.BuildHangingConfig;
import com.atlassian.bamboo.build.test.QuarantineConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.CaptchaConfiguration;
import com.atlassian.bamboo.configuration.ConcurrentBuildConfig;
import com.atlassian.bamboo.configuration.ManualEncryptionConfiguration;
import com.atlassian.bamboo.configuration.RepositorySettings;
import com.atlassian.bamboo.configuration.RssDetectionConfiguration;
import com.atlassian.bamboo.configuration.RssSecurityConfiguration;
import com.atlassian.bamboo.configuration.ScheduleBackupConfiguration;
import com.atlassian.bamboo.configuration.SerializationSecurityConfig;
import com.atlassian.bamboo.configuration.SerializationSecurityMethod;
import com.atlassian.bamboo.configuration.StorageLimits;
import com.atlassian.bamboo.deployments.expiry.DeploymentExpiryConfig;
import com.atlassian.bamboo.deployments.expiry.DeploymentExpiryConfigBuilder;
import com.atlassian.bamboo.docker.BambooDockerHelper;
import com.atlassian.bamboo.util.UrlUtils;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NotThreadSafe
public class AdministrationConfigurationImpl
extends AdministrationConfiguration
implements Serializable {
    private static final Logger log = Logger.getLogger(AdministrationConfigurationImpl.class);
    public static final String DEFAULT_URL = "http://localhost:8085";
    public static final int DEFAULT_BUILD_IN_QUEUE_TIMEOUT = 120;
    public static final int DEFAULT_DASHBOARD_PAGE_SIZE = 50;
    public static final int DEFAULT_BRANCH_DETECTION_INTERVAL = 300;
    public static final SerializationSecurityConfig DEFAULT_SERIALIZATION_SECURITY_CONFIG = new SerializationSecurityConfig(SerializationSecurityMethod.STRICT_BLACKLIST, SerializationSecurityMethod.WHITELIST);
    private String myBaseUrl = "http://localhost:8085";
    private boolean myUseGzipCompression = true;
    private String myInstanceName;
    private boolean deploymentExpiryEnabled;
    private BuildExpiryConfig myBuildExpiryConfiguration;
    private DeploymentExpiryConfig deploymentExpiryConfig;
    private BuildHangingConfig myBuildHangingConfig;
    private ElasticConfiguration elasticConfig;
    private ConcurrentBuildConfig concurrentBuildConfig;
    private StorageLimits storageLimits;
    private int dashboardPageSize = 50;
    private boolean enableSignup = true;
    private boolean enableAnonymousAccess = true;
    private boolean enableViewContactDetails = false;
    private boolean enableRestrictedAdmin = false;
    private boolean soxComplianceModeEnabled = false;
    private boolean remoteAgentFunctionEnabled = false;
    private boolean remoteAgentAuthenticationEnabled = false;
    private Boolean auditLoggingEnabled;
    private boolean gravatarSupportEnabled = true;
    private String gravatarServerUrl = "https://secure.gravatar.com/avatar/";
    private boolean showAdminContactDetailsToAnonymousUsers = false;
    private boolean unauthenticatedRemoteTriggerAllowed;
    private transient UnconfigurableFeatureDefaults unconfigurableFeatureDefaults;
    private CaptchaConfiguration captchaConfiguration;
    private ScheduleBackupConfiguration scheduleBackupConfiguration;
    private Map<String, String> systemProperties = new HashMap<String, String>();
    private int buildHangedInQueueNotificationTimeout = 120;
    private RepositorySettings repositorySettings;
    private int branchDetectionCheckInterval;
    private boolean xsrfProtectionEnabled = true;
    private boolean xsrfAllowsMutativeGets;
    private QuarantineConfiguration quarantineConfiguration;
    private Boolean resolveArtifactContentTypeByExtension;
    private SerializationSecurityConfig serializationSecurityConfig;
    private boolean securityTokenRequiredFromAgents;
    private boolean manageAcceptedSshHostKeys;
    private RssSecurityConfiguration rssSecurityConfiguration;
    private RssDetectionConfiguration rssDetectionConfiguration;
    private ManualEncryptionConfiguration manualEncryptionConfiguration;

    public AdministrationConfigurationImpl(@Nullable UnconfigurableFeatureDefaults unconfigurableFeatureDefaults) {
        this.unconfigurableFeatureDefaults = unconfigurableFeatureDefaults;
    }

    public static void setBuildExpiryConfig(AdministrationConfiguration administrationConfiguration, BuildExpiryConfig buildExpiryConfig, ExpiryScheduler expiryScheduler) {
        administrationConfiguration.setBuildExpiryConfig(buildExpiryConfig);
        expiryScheduler.initialiseSchedule(administrationConfiguration.getBuildExpiryConfig().getCronExpression());
    }

    public String getBaseUrl() {
        return UrlUtils.correctlyFormatUrl((String)this.myBaseUrl);
    }

    public void setBaseUrl(String baseUrl) {
        this.myBaseUrl = baseUrl;
    }

    public boolean isUseGzipCompression() {
        return this.myUseGzipCompression;
    }

    public void setUseGzipCompression(boolean useGzipCompression) {
        this.myUseGzipCompression = useGzipCompression;
    }

    public boolean isEnableSignup() {
        return this.enableSignup;
    }

    public void setEnableSignup(boolean enableSignup) {
        this.enableSignup = enableSignup;
    }

    @NotNull
    private UnconfigurableFeatureDefaults getUnconfigurableFeatureDefaults() {
        Preconditions.checkState((this.unconfigurableFeatureDefaults != null ? 1 : 0) != 0);
        return this.unconfigurableFeatureDefaults;
    }

    public void setUnconfigurableFeatureDefaults(@Nullable UnconfigurableFeatureDefaults unconfigurableFeatureDefaults) {
        this.unconfigurableFeatureDefaults = unconfigurableFeatureDefaults;
    }

    public boolean isEnableAnonymousAccess() {
        return this.enableAnonymousAccess;
    }

    public void setEnableAnonymousAccess(boolean enableAnonymousAccess) {
        this.enableAnonymousAccess = enableAnonymousAccess;
    }

    @NotNull
    public CaptchaConfiguration getCaptchaConfiguration() {
        if (this.captchaConfiguration == null) {
            this.captchaConfiguration = new CaptchaConfiguration();
        }
        return this.captchaConfiguration;
    }

    public void setCaptchaConfiguration(CaptchaConfiguration captchaConfiguration) {
        this.captchaConfiguration = captchaConfiguration;
    }

    @NotNull
    public ConcurrentBuildConfig getConcurrentBuildConfig() {
        if (this.concurrentBuildConfig == null) {
            this.concurrentBuildConfig = new ConcurrentBuildConfig();
        }
        return this.concurrentBuildConfig;
    }

    public void setConcurrentBuildConfig(ConcurrentBuildConfig concurrentBuildConfig) {
        this.concurrentBuildConfig = concurrentBuildConfig;
    }

    public boolean isEnableViewContactDetails() {
        return this.enableViewContactDetails;
    }

    public void setEnableViewContactDetails(boolean enableViewContactDetails) {
        this.enableViewContactDetails = enableViewContactDetails;
    }

    public boolean isDeploymentExpiryEnabled() {
        return this.deploymentExpiryEnabled;
    }

    public void setDeploymentExpiryEnabled(boolean deploymentExpiryEnabled) {
        this.deploymentExpiryEnabled = deploymentExpiryEnabled;
    }

    @NotNull
    public BuildExpiryConfig getBuildExpiryConfig() {
        if (this.myBuildExpiryConfiguration == null) {
            this.myBuildExpiryConfiguration = new BuildExpiryConfig();
        }
        return this.myBuildExpiryConfiguration;
    }

    public void setBuildExpiryConfig(BuildExpiryConfig buildExpiryConfig) {
        this.myBuildExpiryConfiguration = buildExpiryConfig;
    }

    @NotNull
    public DeploymentExpiryConfig getDeploymentExpiryConfig() {
        if (this.deploymentExpiryConfig == null) {
            this.deploymentExpiryConfig = new DeploymentExpiryConfigBuilder().build();
        }
        return this.deploymentExpiryConfig;
    }

    public void setDeploymentExpiryConfig(DeploymentExpiryConfig deploymentExpiryConfig) {
        this.deploymentExpiryConfig = deploymentExpiryConfig;
    }

    @Nullable
    public ElasticConfiguration getElasticConfig() {
        return this.elasticConfig;
    }

    public void setElasticConfig(ElasticConfiguration elasticConfig) {
        this.elasticConfig = elasticConfig;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public void setSystemProperty(String key, String value) {
        if (this.systemProperties == null) {
            this.systemProperties = new HashMap<String, String>();
        }
        this.systemProperties.put(key, value);
    }

    @Nullable
    public String getSystemProperty(String key) {
        if (this.systemProperties == null) {
            return null;
        }
        return this.systemProperties.get(key);
    }

    public ScheduleBackupConfiguration getScheduleBackupConfiguration() {
        return this.scheduleBackupConfiguration;
    }

    public void setScheduleBackupConfiguration(ScheduleBackupConfiguration scheduleBackupConfiguration) {
        this.scheduleBackupConfiguration = scheduleBackupConfiguration;
    }

    @NotNull
    public String getInstanceName() {
        if (this.myInstanceName == null) {
            this.myInstanceName = "Atlassian Bamboo";
        }
        return this.myInstanceName;
    }

    public void setInstanceName(String instanceName) {
        this.myInstanceName = instanceName;
    }

    public boolean isManageAcceptedSshHostKeys() {
        return this.manageAcceptedSshHostKeys;
    }

    public void setManageAcceptedSshHostKeys(boolean manageAcceptedSshHostKeys) {
        this.manageAcceptedSshHostKeys = manageAcceptedSshHostKeys;
    }

    public boolean isRemoteAgentFunctionEnabled() {
        return this.remoteAgentFunctionEnabled;
    }

    public void setRemoteAgentFunctionEnabled(boolean enabled) {
        this.remoteAgentFunctionEnabled = enabled;
    }

    public boolean isRemoteAgentAuthenticationEnabled() {
        return this.remoteAgentAuthenticationEnabled;
    }

    public void setRemoteAgentAuthenticationEnabled(boolean remoteAgentAuthenticationEnabled) {
        this.remoteAgentAuthenticationEnabled = remoteAgentAuthenticationEnabled;
    }

    @NotNull
    public BuildHangingConfig getBuildHangingConfig() {
        if (this.myBuildHangingConfig == null) {
            this.myBuildHangingConfig = new BuildHangingConfig();
        }
        return this.myBuildHangingConfig;
    }

    public void setBuildHangingConfig(BuildHangingConfig myBuildHangingConfig) {
        this.myBuildHangingConfig = myBuildHangingConfig;
    }

    public boolean isGravatarSupportEnabled() {
        return this.gravatarSupportEnabled || StringUtils.isNotBlank((CharSequence)this.getUnconfigurableFeatureDefaults().getAtlassianAccountAvatarBaseUrl());
    }

    public void setGravatarSupportEnabled(boolean gravatarSupportEnabled) {
        this.gravatarSupportEnabled = gravatarSupportEnabled;
    }

    public String getGravatarServerUrl() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)this.getUnconfigurableFeatureDefaults().getAtlassianAccountAvatarBaseUrl(), (CharSequence)this.gravatarServerUrl);
    }

    public void setGravatarServerUrl(String gravatarUrl) {
        this.gravatarServerUrl = gravatarUrl;
    }

    public boolean isShowAdminContactDetailsToAnonymousUsers() {
        return this.showAdminContactDetailsToAnonymousUsers;
    }

    public void setShowAdminContactDetailsToAnonymousUsers(boolean showAdminContactDetailsToAnonymousUsers) {
        this.showAdminContactDetailsToAnonymousUsers = showAdminContactDetailsToAnonymousUsers;
    }

    public boolean isUnauthenticatedRemoteTriggerAllowed() {
        return this.unauthenticatedRemoteTriggerAllowed;
    }

    public void setUnauthenticatedRemoteTriggerAllowed(boolean unauthenticatedRemoteTriggerAllowed) {
        this.unauthenticatedRemoteTriggerAllowed = unauthenticatedRemoteTriggerAllowed;
    }

    public int getBuildHangedInQueueNotificationTimeout() {
        if (this.buildHangedInQueueNotificationTimeout <= 0) {
            return 120;
        }
        return this.buildHangedInQueueNotificationTimeout;
    }

    public void setBuildHangedInQueueNotificationTimeout(int buildHangedInQueueNotificationTimeout) {
        this.buildHangedInQueueNotificationTimeout = buildHangedInQueueNotificationTimeout;
    }

    public boolean isEnableRestrictedAdmin() {
        return this.enableRestrictedAdmin;
    }

    public void setEnableRestrictedAdmin(boolean enableRestrictedAdmin) {
        this.enableRestrictedAdmin = enableRestrictedAdmin;
    }

    public boolean isSoxComplianceModeEnabled() {
        return this.soxComplianceModeEnabled;
    }

    public void setSoxComplianceModeEnabled(boolean soxComplianceModeEnabled) {
        this.soxComplianceModeEnabled = soxComplianceModeEnabled;
    }

    public boolean isAuditLoggingEnabled() {
        if (this.auditLoggingEnabled == null) {
            this.auditLoggingEnabled = true;
        }
        return this.auditLoggingEnabled;
    }

    public void setAuditLoggingEnabled(boolean auditLoggingEnabled) {
        this.auditLoggingEnabled = auditLoggingEnabled;
    }

    public int getDashboardPageSize() {
        return this.dashboardPageSize > 0 ? this.dashboardPageSize : 50;
    }

    public void setDashboardPageSize(int dashboardPageSize) {
        this.dashboardPageSize = dashboardPageSize;
    }

    public int getBranchDetectionCheckInterval() {
        if (this.branchDetectionCheckInterval < 1) {
            this.branchDetectionCheckInterval = 300;
        }
        return this.branchDetectionCheckInterval;
    }

    public void setBranchDetectionCheckInterval(int branchDetectionCheckInterval) {
        this.branchDetectionCheckInterval = branchDetectionCheckInterval;
    }

    @NotNull
    public RepositorySettings getRepositorySettings() {
        if (this.repositorySettings == null) {
            this.repositorySettings = new RepositorySettings();
        }
        return this.repositorySettings;
    }

    public void setRepositorySettings(RepositorySettings repositorySettings) {
        this.repositorySettings = repositorySettings;
    }

    public boolean isXsrfProtectionEnabled() {
        return this.xsrfProtectionEnabled;
    }

    public void setXsrfProtectionEnabled(boolean xsrfProtectionEnabled) {
        this.xsrfProtectionEnabled = xsrfProtectionEnabled;
    }

    public boolean doesXsrfAllowMutativeGets() {
        return this.xsrfAllowsMutativeGets;
    }

    public void setXsrfAllowsMutativeGets(boolean xsrfAllowsMutativeGets) {
        this.xsrfAllowsMutativeGets = xsrfAllowsMutativeGets;
    }

    public boolean getResolveArtifactContentTypeByExtension() {
        if (this.resolveArtifactContentTypeByExtension == null) {
            return false;
        }
        return this.resolveArtifactContentTypeByExtension;
    }

    public void setResolveArtifactContentTypeByExtension(boolean resolveArtifactContentTypeByExtension) {
        this.resolveArtifactContentTypeByExtension = resolveArtifactContentTypeByExtension;
    }

    @NotNull
    public QuarantineConfiguration getQuarantineConfiguration() {
        if (this.quarantineConfiguration == null) {
            this.quarantineConfiguration = new QuarantineConfiguration();
        }
        return this.quarantineConfiguration;
    }

    public void setQuarantineConfiguration(@NotNull QuarantineConfiguration quarantineConfiguration) {
        this.quarantineConfiguration = quarantineConfiguration;
    }

    @NotNull
    public StorageLimits getStorageLimit() {
        return this.storageLimits;
    }

    public void setStorageLimit(@NotNull StorageLimits storageLimits) {
        this.storageLimits = storageLimits;
    }

    @NotNull
    public SerializationSecurityConfig getSerializationSecurityConfig() {
        if (this.serializationSecurityConfig == null) {
            this.serializationSecurityConfig = DEFAULT_SERIALIZATION_SECURITY_CONFIG;
        }
        return this.serializationSecurityConfig;
    }

    public void setSerializationSecurityConfig(@NotNull SerializationSecurityConfig serializationSecurityConfig) {
        this.serializationSecurityConfig = serializationSecurityConfig;
    }

    public boolean isSecurityTokenRequiredFromAgents() {
        return this.securityTokenRequiredFromAgents;
    }

    public void setSecurityTokenRequiredFromAgents(boolean securityTokenRequiredFromAgents) {
        this.securityTokenRequiredFromAgents = securityTokenRequiredFromAgents;
    }

    @NotNull
    public RssSecurityConfiguration getRssSecurityConfiguration() {
        if (this.rssSecurityConfiguration == null) {
            this.rssSecurityConfiguration = new RssSecurityConfiguration(true, true, BambooDockerHelper.DEFAULT_RSS_DOCKER_IMAGE);
        }
        return this.rssSecurityConfiguration;
    }

    public void setRssSecurityConfiguration(RssSecurityConfiguration rssSecurityConfiguration) {
        this.rssSecurityConfiguration = rssSecurityConfiguration;
    }

    public RssDetectionConfiguration getRssDetectionConfiguration() {
        if (this.rssDetectionConfiguration == null) {
            this.rssDetectionConfiguration = new RssDetectionConfiguration();
        }
        return this.rssDetectionConfiguration;
    }

    public void setRssDetectionConfiguration(RssDetectionConfiguration rssDetectionConfiguration) {
        this.rssDetectionConfiguration = rssDetectionConfiguration;
    }

    public ManualEncryptionConfiguration getManualEncryptionConfiguration() {
        if (this.manualEncryptionConfiguration == null) {
            this.manualEncryptionConfiguration = new ManualEncryptionConfiguration();
        }
        return this.manualEncryptionConfiguration;
    }

    public void setManualEncryptionConfiguration(ManualEncryptionConfiguration manualEncryptionConfiguration) {
        this.manualEncryptionConfiguration = manualEncryptionConfiguration;
    }
}

