/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration;

import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationPersister;
import com.atlassian.bamboo.event.AdministrationConfigurationUpdatedEvent;
import com.atlassian.bamboo.persister.Persister;
import com.atlassian.bamboo.utils.XsrfUtils;
import com.atlassian.event.api.EventPublisher;
import org.jetbrains.annotations.NotNull;

public class AdministrationConfigurationPersisterImpl
implements AdministrationConfigurationPersister {
    private final Persister persister;
    private final EventPublisher eventPublisher;

    public AdministrationConfigurationPersisterImpl(Persister persister, EventPublisher eventPublisher) {
        this.persister = persister;
        this.eventPublisher = eventPublisher;
    }

    public void saveAdministrationConfiguration(@NotNull AdministrationConfiguration administrationConfiguration) {
        XsrfUtils.assertCanPerformMutativeAction("Cannot perform mutative operation");
        this.persister.saveAdministrationConfiguration(administrationConfiguration);
        this.eventPublisher.publish((Object)new AdministrationConfigurationUpdatedEvent(administrationConfiguration.getSerializationSecurityConfig()));
    }
}

