/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration;

import com.atlassian.bamboo.configuration.ConfigurationException;
import com.atlassian.bamboo.configuration.ElementParser;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class DefaultContentHandler
implements ContentHandler {
    private Map<String, ElementParser> elementParsers = new HashMap<String, ElementParser>();
    private Stack<ElementParser> currentElementParsers = new Stack();

    protected void registerElementParser(String elementName, ElementParser elementParser) {
        this.elementParsers.put(elementName, elementParser);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String buildName, String buildName1) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String buildName) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!this.hasParserFor(localName)) {
            throw new SAXException("Don't know how to parse " + localName);
        }
        ElementParser elementParser = this.elementParsers.get(localName);
        elementParser.startElement(attributes);
        this.currentElementParsers.push(elementParser);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        ElementParser elementParser = this.currentElementParsers.pop();
        try {
            elementParser.endElement();
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void characters(char[] chars, int start, int end) throws SAXException {
        ElementParser elementParser = this.currentElementParsers.peek();
        elementParser.characters(chars, start, end);
    }

    @Override
    public void ignorableWhitespace(char[] chars, int i, int i1) throws SAXException {
    }

    @Override
    public void processingInstruction(String buildName, String buildName1) throws SAXException {
    }

    @Override
    public void skippedEntity(String buildName) throws SAXException {
    }

    protected boolean hasParserFor(@NotNull String key) {
        return this.elementParsers.containsKey(key);
    }
}

