/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InetAddressBean {
    private static final Logger log = Logger.getLogger(InetAddressBean.class);

    private InetAddressBean() {
    }

    @Nullable
    public static String getCanonicalLocalHostName() {
        return InetAddressBean.getLocalCanonicalHostName(null);
    }

    @Nullable
    public static String getLocalCanonicalHostName(@Nullable String defaultName) {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception e) {
            log.warn((Object)("Cannot determine local host name; using \"" + defaultName + "\"."), (Throwable)e);
            return defaultName;
        }
    }

    @Nullable
    public static String getLocalHostName(@Nullable String defaultName) {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            log.warn((Object)("Cannot determine local host name; using \"" + defaultName + "\"."), (Throwable)e);
            return defaultName;
        }
    }

    @Deprecated
    public static String getLocalHostAddress(String defaultAddress) {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            log.warn((Object)("Cannot determine local host address; using \"" + defaultAddress + "\"."), (Throwable)e);
            return defaultAddress;
        }
    }

    public static Optional<InetAddress> getLocalHostAddress() {
        try {
            return Optional.ofNullable(InetAddress.getLocalHost());
        }
        catch (UnknownHostException e) {
            return Optional.empty();
        }
    }

    public static Optional<String> getLocalHostAddressForUrl() {
        return InetAddressBean.getLocalHostAddress().map(InetAddressBean::formatForUrl);
    }

    private static String formatForUrl(InetAddress address) {
        return address instanceof Inet4Address ? address.getHostAddress() : '[' + address.getHostAddress() + ']';
    }

    public static Iterable<InetAddress> findLoopbacks() {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new IllegalStateException(e);
        }
        if (networkInterfaces == null) {
            return Collections.emptyList();
        }
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            Enumeration<InetAddress> interfaceAddresses = networkInterface.getInetAddresses();
            while (interfaceAddresses.hasMoreElements()) {
                InetAddress address = interfaceAddresses.nextElement();
                if (!address.isLoopbackAddress()) continue;
                addresses.add(address);
            }
        }
        addresses.sort((o1, o2) -> {
            if (o1.getClass() == o2.getClass()) {
                return 0;
            }
            return o1 instanceof Inet4Address ? -1 : 1;
        });
        return addresses;
    }

    @NotNull
    public static InetAddress getLoopback() {
        InetAddress address = (InetAddress)Iterables.getFirst(InetAddressBean.findLoopbacks(), null);
        Preconditions.checkState((address != null ? 1 : 0) != 0, (Object)"System has no loopback interfaces");
        return address;
    }
}

