/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration;

import com.atlassian.bamboo.configuration.ScheduleBackupBean;
import com.atlassian.bamboo.configuration.ScheduleBackupConfiguration;
import com.atlassian.bamboo.configuration.ScheduledBackupJob;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class ScheduleBackupBeanImpl
implements ScheduleBackupBean {
    private static final Logger log = Logger.getLogger(ScheduleBackupBeanImpl.class);
    private static final String BACKUP_JOB_NAME = "BambooAutoBackup";
    private static final String BACKUP_JOB_GROUP_NAME = "BackupGroup";
    private static final JobKey JOB_KEY = new JobKey("BambooAutoBackup", "BackupGroup");
    @Inject
    private Scheduler scheduler;

    public void scheduleBackup(ScheduleBackupConfiguration sbc) throws Exception {
        try {
            this.scheduler.deleteJob(JOB_KEY);
        }
        catch (Exception e) {
            log.error((Object)"Bamboo was unable to schedule the backups. Possibly the old backup is in progress", (Throwable)e);
            throw new Exception("Bamboo was unable to schedule the backups. Possibly the old backup is in progress", e);
        }
        if (!sbc.isDisabled()) {
            JobDetail jobDetail = JobBuilder.newJob(ScheduledBackupJob.class).withIdentity(JOB_KEY).build();
            try {
                CronExpression cronExpression = new CronExpression(sbc.getBackupCronExpression());
                Trigger trigger = TriggerBuilder.newTrigger().withIdentity("BambooAutomatedBackups").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((CronExpression)cronExpression)).startNow().build();
                this.scheduler.scheduleJob(jobDetail, trigger);
            }
            catch (Exception e) {
                log.error((Object)"Bamboo failed to schedule the backups", (Throwable)e);
                throw new Exception("Bamboo failed to schedule the backups", e);
            }
        }
    }
}

