/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration;

import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.ScheduleBackupConfiguration;
import com.atlassian.bamboo.logger.AdminErrorHandler;
import com.atlassian.bamboo.migration.ExportDetailsBean;
import com.atlassian.bamboo.migration.ImportExportManager;
import com.atlassian.bamboo.persister.Persister;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.spring.container.ContainerManager;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ScheduledBackupJob
implements Job {
    private static final Logger log = Logger.getLogger(ScheduledBackupJob.class);
    public static final String BACKUP_PATH = "backupPath";
    public static final String BACKUP_FREQUENCY = "backupFrequency";
    public static final String BACKUP_TIME = "backupTime";
    public static final String BACKUP_FILE_PREFIX = "backupFilePrefix";
    public static final String BACKUP_FILE_FORMAT = "backupFileFormat";
    public static final int NUMBER_OF_MILLISECONDS_IN_A_DAY = 86400000;
    public static final String BAMBOO_DATE_FORMAT = "yyyy_MM_dd";
    public static final String LAST_RAN_DATE = "lastRanDate";
    private AdminErrorHandler adminErrorHandler;
    private static final String BAMBOO_NICE_DATE_FORMAT = "dd MMM yyyy";
    private ImportExportManager importExportManager;
    private BootstrapManager bootstrapManager;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        AdministrationConfiguration adminConfiguration = this.getAdministrationConfig();
        ScheduleBackupConfiguration sbc = adminConfiguration.getScheduleBackupConfiguration();
        if (sbc.isDisabled()) {
            return;
        }
        String path = sbc.getBackupPath(this.getBootstrapManager().getApplicationHome());
        String prefix = sbc.getBackupFilePrefix();
        String fileDateFormat = sbc.getBackupFileFormat();
        SimpleDateFormat dateFormat = new SimpleDateFormat(fileDateFormat);
        String today = dateFormat.format(new Date());
        String fileName = prefix + today + ".zip";
        File backupFile = new File(path, fileName);
        try {
            ExportDetailsBean details = new ExportDetailsBean();
            details.setPath(backupFile.getPath());
            details.setExportBuildLogs(true);
            details.setExportResults(true);
            details.setExportArtifacts(sbc.isExportArtifacts());
            details.setAwaitJobCompletion(sbc.isAwaitJobCompletion());
            this.getImportExportManager().bambooExport(details);
            sbc.setLastRanDate(new Date());
            adminConfiguration.setScheduleBackupConfiguration(sbc);
            this.getDefaultPersister().saveAdministrationConfiguration(adminConfiguration);
        }
        catch (Exception e) {
            String date = new SimpleDateFormat(BAMBOO_NICE_DATE_FORMAT).format(new Date());
            this.getAdminErrorHandler().recordError("backup.error.failed", "Bamboo failed to run the backup on " + date + ".  See the logs for further details.");
            log.error((Object)e, (Throwable)e);
        }
    }

    private AdministrationConfiguration getAdministrationConfig() {
        Persister defaultPersister = this.getDefaultPersister();
        AdministrationConfiguration administrationConfiguration = defaultPersister.getAdministrationConfiguration();
        return administrationConfiguration;
    }

    private Persister getDefaultPersister() {
        return (Persister)ContainerManager.getComponent((String)"persister");
    }

    public ImportExportManager getImportExportManager() {
        if (this.importExportManager == null) {
            this.importExportManager = (ImportExportManager)ContainerManager.getComponent((String)"importExportManager");
        }
        return this.importExportManager;
    }

    private AdminErrorHandler getAdminErrorHandler() {
        if (this.adminErrorHandler == null) {
            this.adminErrorHandler = (AdminErrorHandler)ContainerManager.getComponent((String)"adminErrorHandler");
        }
        return this.adminErrorHandler;
    }

    public BootstrapManager getBootstrapManager() {
        if (this.bootstrapManager == null) {
            this.bootstrapManager = (BootstrapManager)ContainerManager.getComponent((String)"bootstrapManager");
        }
        return this.bootstrapManager;
    }
}

