/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration;

import com.atlassian.annotations.PublicApi;
import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.configuration.InetAddressBean;
import com.atlassian.bamboo.configuration.StartupStatisticsBean;
import com.atlassian.bamboo.configuration.SystemInfo;
import com.atlassian.bamboo.fileserver.SystemDirectory;
import com.atlassian.bamboo.plugin.RemoteAgentSupported;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.storage.StorageLocationService;
import com.atlassian.config.HomeLocator;
import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.core.util.DateUtils;
import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.log4j.Logger;
import org.apache.tools.ant.taskdefs.Execute;
import org.jetbrains.annotations.Nullable;

@RemoteAgentSupported
@PublicApi
public class SystemInfoImpl
extends SystemInfo
implements Serializable {
    private static final Logger log = Logger.getLogger(SystemInfo.class);
    private static final Format DATE_FORMAT = FastDateFormat.getInstance((String)"EEEEE, dd MMM yyyy");
    private static final Format TIME_FORMAT = FastDateFormat.getInstance((String)"HH:mm:ss");
    private static final long MEGABYTE = 0x100000L;
    private String userName;
    private String userTimezone;
    private String userLocale;
    private String systemEncoding;
    private String operatingSystem;
    private String operatingSystemArchitecture;
    private String systemDate;
    private String systemTime;
    private String tempDir;
    private String userHome;
    private long totalMemory;
    private long freeMemory;
    private long usedMemory;
    private int availableProcessors;
    private long startupTimestamp;
    private final String currentDirectory;
    private final String applicationHome;
    private final String buildWorkingDirectory;
    private final Date currentDate;
    private Long freeDiskSpace;
    private String hostName;
    private String ipAddress;

    public SystemInfoImpl() {
        this(null, null, null);
    }

    public SystemInfoImpl(@Nullable StartupStatisticsBean startupStatisticsBean, @Nullable BuildDirectoryManager buildDirectoryManager, @Nullable HomeLocator homeLocator) {
        Properties sysProps = System.getProperties();
        Runtime runtime = Runtime.getRuntime();
        this.currentDate = new Date();
        this.systemDate = DATE_FORMAT.format(this.currentDate);
        this.systemTime = TIME_FORMAT.format(this.currentDate);
        this.userName = sysProps.getProperty("user.name");
        this.userTimezone = sysProps.getProperty("user.timezone");
        this.userLocale = Locale.getDefault() == null ? "null" : Locale.getDefault().getDisplayName();
        this.userHome = sysProps.getProperty("user.home");
        this.systemEncoding = sysProps.getProperty("file.encoding");
        this.operatingSystem = sysProps.getProperty("os.name") + " " + sysProps.getProperty("os.version");
        this.operatingSystemArchitecture = sysProps.getProperty("os.arch");
        this.tempDir = sysProps.getProperty("java.io.tmpdir");
        this.availableProcessors = runtime.availableProcessors();
        double dblTotal = (double)runtime.totalMemory() / 1048576.0;
        double dblFree = (double)runtime.freeMemory() / 1048576.0;
        this.usedMemory = Math.round(dblTotal - dblFree);
        this.totalMemory = Math.round(dblTotal);
        this.freeMemory = Math.round(dblFree);
        this.currentDirectory = new File("").getAbsolutePath();
        this.hostName = InetAddressBean.getLocalCanonicalHostName("Unknown");
        this.ipAddress = InetAddressBean.getLocalHostAddress().map(InetAddress::getHostAddress).orElse("Unknown");
        if (startupStatisticsBean != null) {
            this.startupTimestamp = startupStatisticsBean.getStartupTimestamp();
        }
        this.buildWorkingDirectory = buildDirectoryManager != null ? buildDirectoryManager.getWorkingDirectoryOfCurrentAgent().getAbsolutePath() : null;
        if (homeLocator != null) {
            String homePath = homeLocator.getHomePath();
            this.applicationHome = new File(homePath).getAbsolutePath();
        } else {
            this.applicationHome = null;
        }
        this.freeDiskSpace = 0L;
        try {
            String applicationHome1 = this.getApplicationHome();
            if (applicationHome1 != null) {
                this.freeDiskSpace = Files.getFileStore(Paths.get(applicationHome1, new String[0])).getUsableSpace() / 1024L;
            }
        }
        catch (Exception e) {
            log.info((Object)"Can't get free disk space. A warning returned.", (Throwable)e);
            this.freeDiskSpace = null;
        }
    }

    public long getStartupTimestamp() {
        return this.startupTimestamp;
    }

    public Date getCurrentDate() {
        return this.currentDate;
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public String getUptime() {
        long currentTime = System.currentTimeMillis();
        return DateUtils.dateDifference((long)this.startupTimestamp, (long)currentTime, (long)4L, (ResourceBundle)ResourceBundle.getBundle("com.atlassian.bamboo.ww2.BambooActionSupport")) + " (since " + new Date(this.startupTimestamp) + ")";
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public String getSystemDate() {
        return this.systemDate;
    }

    public String getSystemTime() {
        return this.systemTime;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserTimezone() {
        return this.userTimezone;
    }

    public String getUserLocale() {
        return this.userLocale;
    }

    public String getUserHome() {
        return this.userHome;
    }

    public String getBambooLogsDirectoryPath() {
        return SystemDirectory.getBambooLogsDirectory().getAbsolutePath();
    }

    public String getSystemEncoding() {
        return this.systemEncoding;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public String getOperatingSystemArchitecture() {
        return this.operatingSystemArchitecture;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public long getUsedMemory() {
        return this.usedMemory;
    }

    public int getAvailableProcessors() {
        return this.availableProcessors;
    }

    @Nullable
    public String getApplicationHome() {
        if (this.applicationHome != null) {
            return this.applicationHome;
        }
        AtlassianBootstrapManager bootstrapManager = BootstrapUtils.getBootstrapManager();
        return bootstrapManager != null ? bootstrapManager.getApplicationHome() : null;
    }

    public String getBuildWorkingDirectory() {
        if (this.buildWorkingDirectory != null) {
            return this.buildWorkingDirectory;
        }
        return SystemDirectory.getBaseBuildWorkingDirectory().getAbsolutePath();
    }

    public String getArtifactsDirectory() {
        return ((StorageLocationService)ComponentAccessor.STORAGE_LOCATION_SERVICE.get()).getDefaultArtifactDirectoryBuilder().getRootDirectory().getPath();
    }

    @Nullable
    public String getFreeDiskSpace() {
        return this.freeDiskSpace != null ? FileUtils.byteCountToDisplaySize((long)(this.freeDiskSpace * 1024L)) : null;
    }

    public String getSystemProperty(String key) {
        return System.getProperties().getProperty(key, "");
    }

    public String getConfigPath() {
        return ((BootstrapManager)BootstrapUtils.getBootstrapManager()).getConfigDirectory();
    }

    public String getBuildPath() {
        return ((BootstrapManager)BootstrapUtils.getBootstrapManager()).getBuildDirectory();
    }

    public String getIndexSize() {
        File indexDir = new File(this.getApplicationHome(), "index");
        if (indexDir.exists()) {
            long space = FileUtils.sizeOfDirectory((File)indexDir);
            return FileUtils.byteCountToDisplaySize((long)space);
        }
        return "Folder doesn't exist";
    }

    public Collection getEnvironmentVariables() {
        ArrayList env = new ArrayList((Collection)Execute.getProcEnvironment().clone());
        Collections.sort(env);
        return env;
    }

    public Collection getSystemProperties() {
        Properties properties = System.getProperties();
        ArrayList<Map.Entry<Object, Object>> entries = new ArrayList<Map.Entry<Object, Object>>(properties.entrySet());
        Collections.sort(entries, new Comparator(){

            public int compare(Object o, Object o1) {
                Map.Entry e = (Map.Entry)o;
                Map.Entry e1 = (Map.Entry)o1;
                return new CompareToBuilder().append(e.getKey(), e1.getKey()).toComparison();
            }
        });
        return entries;
    }

    public String fullOutput() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public String toString() {
        return "System info for " + this.getHostName() + " at " + this.getCurrentDate();
    }
}

