/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.external.exporters;

import com.atlassian.bamboo.build.docker.DockerPipelineConfigurationImpl;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;

public class HierarchicalConfigurationExporterInternal {
    private String VALUE_KEY = "__value__";
    private static final List<String> KEYS_TO_SKIP = ImmutableList.of((Object)ConfigUtils.BAMBOO_DELIMITER_PARSING_DISABLED, (Object)"isMergedConfiguration", (Object)"buildStrategies", (Object)"triggers", (Object)"buildTasks", (Object)"branchConfiguration", (Object)"branchIntegration", (Object)"branches", (Object)"custom.dependencies", (Object)"repository.common.quietPeriod.enabled", (Object)"repository.common.quietPeriod.period", (Object)"repository.common.quietPeriod.maxRetries", (Object[])new String[]{"changeset.filter.pattern.regex", "commit.isolation.option", "filter.pattern.option", "filter.pattern.regex", DockerPipelineConfigurationImpl.CONFIG_FIELD_PREFIX});
    private static final Map<String, Set<Object>> DEFAULT_VALUES_TO_SKIP = ImmutableMap.of((Object)"cleanWorkingDirectory", (Object)ImmutableSet.of((Object)Boolean.FALSE), (Object)"repositoryDefiningWorkingDirectory", (Object)ImmutableSet.of((Object)0L, (Object)-1L));

    public HierarchicalConfigurationExporterInternal() {
    }

    public HierarchicalConfigurationExporterInternal(String valueKey) {
        this.VALUE_KEY = valueKey;
    }

    @VisibleForTesting
    List<String> getKeysToSkip() {
        return KEYS_TO_SKIP;
    }

    private void addNode(ConfigurationNode node, Map<String, Object> data) {
        this.addNode(node.getName(), node, data);
    }

    private void putIfNotNull(String name, Object value, Map<String, Object> data) {
        if (value != null) {
            data.put(name, value);
        }
    }

    private Multimap<String, ConfigurationNode> getChildrenNodesByName(ConfigurationNode node) {
        ArrayListMultimap nodes = ArrayListMultimap.create();
        List children = node.getChildren();
        for (ConfigurationNode child : children) {
            nodes.put((Object)child.getName(), (Object)child);
        }
        return nodes;
    }

    private void addNodes(String name, Collection<ConfigurationNode> nodes, Map<String, Object> data) {
        if (nodes.size() == 1) {
            this.addNode(name, (ConfigurationNode)Iterables.getOnlyElement(nodes), data);
        } else {
            ArrayList<Object> objectList = new ArrayList<Object>();
            for (ConfigurationNode node : nodes) {
                if (CollectionUtils.isNotEmpty((Collection)node.getChildren())) {
                    LinkedHashMap<String, Object> nodeData = new LinkedHashMap<String, Object>();
                    this.putIfNotNull(this.VALUE_KEY, node.getValue(), nodeData);
                    Multimap<String, ConfigurationNode> childrenByName = this.getChildrenNodesByName(node);
                    childrenByName.keySet().forEach(key -> {
                        Collection children = childrenByName.get(key);
                        this.addNodes((String)key, children, (Map<String, Object>)nodeData);
                    });
                    objectList.add(nodeData);
                    continue;
                }
                objectList.add(node.getValue());
            }
            data.put(name, objectList);
        }
    }

    private String qualifiedChildName(String parentName, String childName) {
        return parentName + '.' + childName;
    }

    private void addNode(String name, ConfigurationNode node, Map<String, Object> data) {
        Multimap<String, ConfigurationNode> childrenByName = this.getChildrenNodesByName(node);
        if (!childrenByName.isEmpty()) {
            if (childrenByName.keySet().size() == 1 || node.getValue() != null) {
                this.putIfNotNull(name, node.getValue(), data);
                childrenByName.keySet().forEach(key -> {
                    Collection children = childrenByName.get(key);
                    this.addNodes(this.qualifiedChildName(name, (String)key), children, data);
                });
            } else {
                LinkedHashMap nodeData = new LinkedHashMap();
                childrenByName.keySet().forEach(key -> {
                    Collection children = childrenByName.get(key);
                    this.addNodes((String)key, children, nodeData);
                });
                this.putIfNotNull(name, nodeData, data);
            }
        } else {
            this.putIfNotNull(name, node.getValue(), data);
        }
    }

    public Map<String, Object> generateDataMap(HierarchicalConfiguration originalConfiguration) {
        HierarchicalConfiguration configuration = (HierarchicalConfiguration)originalConfiguration.clone();
        this.getKeysToSkip().forEach(arg_0 -> ((HierarchicalConfiguration)configuration).clearTree(arg_0));
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        Multimap<String, ConfigurationNode> childrenByName = this.getChildrenNodesByName(configuration.getRootNode());
        childrenByName.keySet().forEach(key -> this.addNodes((String)key, childrenByName.get(key), (Map<String, Object>)data));
        DEFAULT_VALUES_TO_SKIP.forEach((key, valueSet) -> valueSet.forEach(value -> {
            if (value.equals(data.get(key))) {
                data.remove(key);
            }
        }));
        return data;
    }

    private void addListToConfig(HierarchicalConfiguration configuration, String key, List<Object> list, Set<String> keysAdded) {
        list.forEach(i -> {
            if (i instanceof Map) {
                Map map = (Map)i;
                if (map.containsKey(this.VALUE_KEY)) {
                    this.addValueToConfig(configuration, key + "(-1)", map.get(this.VALUE_KEY), keysAdded);
                    this.addMapToConfig(configuration, key, map, false, keysAdded);
                } else {
                    this.addMapToConfig(configuration, key, map, true, keysAdded);
                }
            } else {
                this.addValueToConfig(configuration, key + "(-1)", i, keysAdded);
            }
        });
    }

    private void addMapToConfig(HierarchicalConfiguration configuration, String key, Map<String, Object> map, boolean addIndexOnFirstItem, Set<String> keysAdded) {
        boolean first = true;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (this.VALUE_KEY.equals(entry.getKey())) continue;
            if (first && addIndexOnFirstItem) {
                this.addValueToConfig(configuration, key + "(-1)." + entry.getKey(), entry.getValue(), keysAdded);
            } else {
                this.addValueToConfig(configuration, key + "." + entry.getKey(), entry.getValue(), keysAdded);
            }
            first = false;
        }
    }

    private void addValueToConfig(HierarchicalConfiguration configuration, String key, Object value, Set<String> keysAdded) {
        if (!(value instanceof Map) && !keysAdded.contains(key)) {
            configuration.clearTree(key);
            keysAdded.add(key);
        }
        if (value instanceof List) {
            this.addListToConfig(configuration, key, (List)value, keysAdded);
        } else if (value instanceof Map) {
            this.addMapToConfig(configuration, key, (Map)value, false, keysAdded);
        } else {
            configuration.addProperty(key, (Object)value.toString());
        }
    }

    public HierarchicalConfiguration fromDataMap(Map<String, Object> configurationMap) {
        XMLConfiguration configuration = new XMLConfiguration();
        this.addDataMapToConfiguration((HierarchicalConfiguration)configuration, configurationMap);
        return configuration;
    }

    public void addDataMapToConfiguration(HierarchicalConfiguration configuration, Map<String, Object> configurationMap) {
        if (MapUtils.isNotEmpty(configurationMap)) {
            configurationMap.forEach((k, v) -> this.addValueToConfig(configuration, (String)k, v, (Set<String>)new HashSet<String>()));
        }
    }
}

