/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.container;

import com.atlassian.bamboo.Bamboo;
import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.ServerLifecycleManager;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationManager;
import com.atlassian.bamboo.build.BuildSuspensionCheckBean;
import com.atlassian.bamboo.build.artifact.LocalArtifactManager;
import com.atlassian.bamboo.build.monitoring.BuildMonitorJobScheduler;
import com.atlassian.bamboo.build.monitoring.BuildQueueMonitorJobScheduler;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.buildqueue.manager.RemoteAgentManager;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.ScheduleBackupBean;
import com.atlassian.bamboo.configuration.ScheduleBackupConfiguration;
import com.atlassian.bamboo.configuration.external.RssDetectionService;
import com.atlassian.bamboo.container.PersisterFactory;
import com.atlassian.bamboo.container.startup.InitialiseTrustedAppsOnStartup;
import com.atlassian.bamboo.container.startup.PendingBuildResultsStateRestoration;
import com.atlassian.bamboo.crypto.instance.SecretEncryptionServiceInternal;
import com.atlassian.bamboo.deployments.cache.LinkedDeploymentProjectCacheService;
import com.atlassian.bamboo.deployments.container.PendingDeploymentResultsRestoration;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.event.ServerStartedEvent;
import com.atlassian.bamboo.event.ServerStartingEvent;
import com.atlassian.bamboo.fileserver.SystemDirectory;
import com.atlassian.bamboo.logger.ErrorDetails;
import com.atlassian.bamboo.logger.ErrorHandler;
import com.atlassian.bamboo.persister.Persister;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.branch.BranchDetectionJobScheduler;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.plan.pullrequest.PullRequestDetectionJobScheduler;
import com.atlassian.bamboo.plugin.BambooPluginManager;
import com.atlassian.bamboo.plugin.xwork.XWorkPluginConfigurationMaintainer;
import com.atlassian.bamboo.repository.CachedRepositoryDefinitionManager;
import com.atlassian.bamboo.repository.RepositoryDefinition;
import com.atlassian.bamboo.rest.DefaultSessionManager;
import com.atlassian.bamboo.rest.SessionManager;
import com.atlassian.bamboo.schedule.BambooScheduler;
import com.atlassian.bamboo.security.ImpersonationHelper;
import com.atlassian.bamboo.security.SecureTokenService;
import com.atlassian.bamboo.server.control.ChangeDetectionController;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.trigger.TriggerActivatorHelper;
import com.atlassian.bamboo.trigger.TriggerTypeManager;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.util.BambooSpringUtils;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.v2.build.agent.HeartBeatCheckerJobScheduler;
import com.atlassian.bamboo.v2.build.agent.MessageListenerContainerController;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityDefaultsHelper;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityScope;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetManager;
import com.atlassian.bamboo.v2.build.agent.capability.LocalCapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.RemoteCapabilitySet;
import com.atlassian.bamboo.v2.build.queue.BuildQueueManager;
import com.atlassian.bamboo.xmpp.BambooSmackClient;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.servlet.ServletModuleManager;
import com.atlassian.plugin.servlet.util.ServletContextServletModuleManagerAccessor;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.springframework.scheduling.quartz.SimpleTriggerFactoryBean;
import org.springframework.stereotype.Component;

@Component
public class BambooContainer
implements Bamboo {
    private static final Logger log = Logger.getLogger(BambooContainer.class);
    @Inject
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;
    @Inject
    private BootstrapManager bootstrapManager;
    @Inject
    private BambooPluginManager pluginManager;
    @Inject
    private ErrorHandler errorHandler;
    @Inject
    private AgentManager agentManager;
    @Inject
    private RemoteAgentManager remoteAgentManager;
    @Inject
    private Persister persister;
    @Inject
    private BambooUserManager bambooUserManager;
    @Inject
    private ImmutablePlanCacheService immutablePlanCacheService;
    @Inject
    private CachedPlanManager cachedPlanManager;
    @Inject
    private EventPublisher eventPublisher;
    @Inject
    private ScheduleBackupBean scheduleBackupBean;
    @Inject
    private ServletModuleManager servletModuleManager;
    @Inject
    private HeartBeatCheckerJobScheduler heartBeatCheckerJobScheduler;
    @Inject
    private BuildMonitorJobScheduler buildMonitorJobScheduler;
    @Inject
    private BranchDetectionJobScheduler branchDetectionJobScheduler;
    @Inject
    private PullRequestDetectionJobScheduler pullRequestDetectionJobScheduler;
    @Inject
    private List<BambooScheduler> bambooSchedulers;
    @Inject
    private BuildQueueMonitorJobScheduler buildQueueMonitorJobScheduler;
    @Inject
    private BambooSmackClient bambooSmackClient;
    @Inject
    private Scheduler scheduler;
    private SessionManager sessionManager;
    @Inject
    private BuildSuspensionCheckBean buildSuspensionCheckBean;
    @Inject
    private ElasticImageConfigurationManager elasticImageConfigurationManager;
    @Inject
    private CapabilitySetManager capabilitySetManager;
    @Inject
    private CapabilityDefaultsHelper capabilityDefaultsHelper;
    @Inject
    private ServerLifecycleManager serverLifecycleManager;
    @Inject
    private List<SimpleTriggerFactoryBean> bambooTriggers;
    @Inject
    private EnvironmentService environmentService;
    @Inject
    private LinkedDeploymentProjectCacheService linkedDeploymentProjectCacheService;
    @Inject
    private TriggerTypeManager triggerTypeManager;
    @Inject
    private ChangeDetectionController changeDetectionController;
    @Inject
    private PendingBuildResultsStateRestoration pendingBuildResultsStateRestoration;
    @Inject
    private PendingDeploymentResultsRestoration pendingDeploymentResultsRestoration;
    @Inject
    private BuildQueueManager buildQueueManager;
    @Inject
    private LocalArtifactManager localArtifactManager;
    @Inject
    private SecureTokenService secureTokenService;
    @Inject
    private MessageListenerContainerController messageListenerContainerController;
    @Inject
    private CachedRepositoryDefinitionManager cachedRepositoryDefinitionManager;
    @Inject
    private SecretEncryptionServiceInternal secretEncryptionServiceInternal;
    @Inject
    private RssDetectionService rssDetectionService;
    private static volatile BambooContainer BAMBOO_CONTAINER;

    public void initialise() throws Exception {
        BAMBOO_CONTAINER = this;
        this.init();
    }

    protected void init() throws PluginParseException {
        this.initializeHomeDirectoryClassWhitelist();
        log.info((Object)"Initialising Authentication...");
        ImpersonationHelper.escalateCurrentThreadToSystemAuthority();
        try {
            XWorkPluginConfigurationMaintainer.suspendReloads();
            Stopwatch stopWatch = Stopwatch.createStarted();
            log.info((Object)"Initialising the plugin system...");
            this.pluginManager.init();
            log.info((Object)("Plugin system available, after " + stopWatch));
        }
        finally {
            XWorkPluginConfigurationMaintainer.resumeReloads();
        }
        PersisterFactory.setPersister(this.persister);
        this.sessionManager = new DefaultSessionManager(this.bambooUserManager);
    }

    public void start(@NotNull ServletContext servletContext) throws Exception {
        try {
            log.info((Object)"Starting Bamboo...");
            log.info((Object)"Reticulating splines...");
            this.serverLifecycleManager.serverStarting();
            ServletContextServletModuleManagerAccessor.setServletModuleManager((ServletContext)servletContext, (ServletModuleManager)this.servletModuleManager);
            this.registerCustomEventListeners();
            BambooSpringUtils.autowireComponent(new InitialiseTrustedAppsOnStartup()).run();
            this.eventPublisher.publish((Object)new ServerStartingEvent(this.bootstrapManager.getFingerprint()));
            this.localArtifactManager.cleanupTemporaryArtifactStorage();
            this.persister.start();
            this.initializeEncryptionKeys();
            this.agentManager.initAgents();
            this.agentManager.startLocalAgents();
            this.setupDefaultCapabilities();
            try {
                this.elasticImageConfigurationManager.updateDefaultElasticImageConfiguration();
            }
            catch (Exception e) {
                this.errorHandler.recordElasticError(e.getMessage(), null, (Throwable)e, null);
                log.error((Object)"Unable to update elastic configuration.", (Throwable)e);
            }
            this.buildSuspensionCheckBean.isSuspended();
            this.initialisePlans();
            this.messageListenerContainerController.startAll();
            try {
                this.remoteAgentManager.start();
            }
            catch (Exception e) {
                this.errorHandler.recordElasticError("Unable to start broker. Please check you settings in the bamboo.cfg.xml in your Bamboo Home. Remote agents will not work correctly.", null, (Throwable)e, null);
                log.error((Object)"Unable to start broker.", (Throwable)e);
            }
            this.serverLifecycleManager.serverRunning();
            this.initialiseTriggers();
            this.startJobScheduler();
            log.info((Object)("Bamboo version " + BuildUtils.getCurrentVersion() + " initialised OK"));
            this.eventPublisher.publish((Object)new ServerStartedEvent(this.bootstrapManager.getFingerprint()));
        }
        catch (Exception e) {
            log.fatal((Object)"Cannot start Bamboo", (Throwable)e);
            throw e;
        }
    }

    protected void startJobScheduler() {
        try {
            if (this.scheduler.isInStandbyMode()) {
                this.scheduler.start();
                return;
            }
            ScheduleBackupConfiguration sbc = this.administrationConfigurationAccessor.getAdministrationConfiguration().getScheduleBackupConfiguration();
            try {
                if (sbc != null) {
                    this.scheduleBackupBean.scheduleBackup(sbc);
                }
            }
            catch (Exception e) {
                log.error((Object)"Error initiating backup schedule", (Throwable)e);
            }
            this.buildMonitorJobScheduler.scheduleBuildMonitoring();
            this.branchDetectionJobScheduler.scheduleBranchDetecting();
            this.pullRequestDetectionJobScheduler.schedulePullRequestDetecting();
            this.heartBeatCheckerJobScheduler.scheduleHeartBeatJob();
            this.buildQueueMonitorJobScheduler.scheduleBuildQueueMonitoring();
            this.bambooSchedulers.forEach(BambooScheduler::initialiseSchedule);
            for (SimpleTriggerFactoryBean triggerFactory : this.bambooTriggers) {
                SimpleTrigger trigger = triggerFactory.getObject();
                JobDetail jobDetail = (JobDetail)trigger.getJobDataMap().get((Object)"jobDetail");
                this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            }
        }
        catch (SchedulerException e) {
            log.error((Object)"Error starting scheduler", (Throwable)e);
        }
    }

    private void stopJobScheduler() {
        for (Triggerable triggerable : Iterables.concat((Iterable)this.cachedPlanManager.getPlans(ImmutableChain.class), (Iterable)this.environmentService.getAllEnvironmentsNoUserContext())) {
            TriggerActivatorHelper.deactivateTriggers(this.triggerTypeManager, triggerable, log);
        }
        this.bambooSchedulers.forEach(BambooScheduler::destroySchedule);
        try {
            this.scheduler.shutdown();
        }
        catch (SchedulerException e) {
            log.error((Object)"Error stopping scheduler", (Throwable)e);
        }
    }

    private void initializeEncryptionKeys() {
        if (!SystemProperty.DISABLE_ENCRYPTION.getTypedValue()) {
            this.secretEncryptionServiceInternal.encrypt("hello world");
        }
    }

    public void initialisePlansAfterImport() throws IOException {
        log.info((Object)"Initialising plans and environments ...");
        BambooFileUtils.cleanDirectory(SystemDirectory.getServerStateDirectory());
        this.cachedRepositoryDefinitionManager.initialiseCache();
        this.immutablePlanCacheService.initialiseCache();
        this.linkedDeploymentProjectCacheService.initialiseCache();
        this.initialiseTriggers();
    }

    private void initialisePlans() throws IOException {
        log.info((Object)"Initialising plans and environments ...");
        this.cachedRepositoryDefinitionManager.initialiseCache();
        this.immutablePlanCacheService.initialiseCache();
        this.linkedDeploymentProjectCacheService.initialiseCache();
        HashSet<ResultKey> restoredResults = new HashSet<ResultKey>();
        restoredResults.addAll(this.pendingBuildResultsStateRestoration.restoreState());
        restoredResults.addAll(this.pendingDeploymentResultsRestoration.restoreState());
        if (SystemProperty.BAMBOO_IGNORE_SERVER_STATE_ON_RESTART.getTypedValue()) {
            BambooFileUtils.cleanDirectory(SystemDirectory.getServerStateDirectory());
        } else {
            this.secureTokenService.restoreState();
            this.buildQueueManager.restoreState(restoredResults);
        }
        this.rssDetectionService.cleanUnfinishedSpecsAndInitService();
    }

    private void initialiseTriggers() {
        ChangeDetectionController.ShutdownMarker lastShutdownMarker = this.changeDetectionController.getShutdownMarkerIfAvailable();
        Date lastShutdownTime = null;
        if (lastShutdownMarker != null) {
            lastShutdownTime = lastShutdownMarker.getShutdownDate();
        }
        for (Triggerable triggerable : Iterables.concat((Iterable)this.cachedPlanManager.getPlans(ImmutableChain.class), (Iterable)this.environmentService.getAllEnvironmentsNoUserContext())) {
            TriggerActivatorHelper.initAndActivateTriggers(this.triggerTypeManager, triggerable, log, lastShutdownTime);
        }
    }

    private void setupDefaultCapabilities() {
        if (this.capabilitySetManager.getSharedLocalCapabilitySet() == null) {
            LocalCapabilitySet localShared = new LocalCapabilitySet(CapabilityScope.SHARED);
            localShared = this.capabilityDefaultsHelper.addDefaultCapabilities((CapabilitySet)localShared);
            this.capabilitySetManager.saveCapabilitySet((CapabilitySet)localShared);
        }
        if (this.capabilitySetManager.getSharedRemoteCapabilitySet() == null) {
            RemoteCapabilitySet remoteShared = new RemoteCapabilitySet(CapabilityScope.SHARED);
            this.capabilitySetManager.saveCapabilitySet((CapabilitySet)remoteShared);
        }
    }

    public void registerCustomEventListeners() {
        Map defaultListeners = (Map)ContainerManager.getComponent((String)"defaultListeners");
        for (Map.Entry entry : defaultListeners.entrySet()) {
            this.eventPublisher.register(entry.getValue());
            log.info((Object)("Registered a default event listener: " + (String)entry.getKey()));
        }
    }

    public void reportBuildConfigurationProblems(Persister persister, ErrorHandler errorHandler) {
        if (Boolean.parseBoolean(System.getProperty("atlassian.bamboo.build.disable"))) {
            return;
        }
        log.info((Object)"Validating Builder and Repository configurations for Builds...");
        for (ImmutablePlan plan : this.cachedPlanManager.getPlans(ImmutablePlan.class)) {
            log.info((Object)("Checking build " + plan.getName()));
            this.reportTaskAndRepositoryProblems(plan, errorHandler);
        }
    }

    private void reportTaskAndRepositoryProblems(ImmutablePlan plan, ErrorHandler errorHandler) {
        ImmutableChain chain = (ImmutableChain)Narrow.to((Object)plan, ImmutableChain.class);
        if (chain != null) {
            List repositoryDefinitions = chain.getEffectiveRepositoryDefinitions();
            for (RepositoryDefinition repositoryDefinition : repositoryDefinitions) {
                try {
                    repositoryDefinition.getRepository();
                }
                catch (Exception e) {
                    errorHandler.recordError((Key)plan.getPlanKey(), "Incorrect repository definition found for plan. Has the repository plugin been uninstalled?");
                }
            }
        }
        List taskDefinitions = plan.getBuildDefinition().getTaskDefinitions();
        for (TaskDefinition taskDefinition : taskDefinitions) {
            ModuleDescriptor moduleDescriptor = this.pluginManager.getEnabledPluginModule(taskDefinition.getPluginKey());
            if (moduleDescriptor != null && TaskType.class.isAssignableFrom(moduleDescriptor.getModuleClass())) continue;
            errorHandler.recordError((Key)plan.getPlanKey(), "No task plugin (" + taskDefinition.getPluginKey() + ") found for Job. Has the task plugin been uninstalled?");
        }
    }

    @VisibleForTesting
    void initializeHomeDirectoryClassWhitelist() {
        File whitelistFile = this.getHomeDirectoryClassWhitelistFile();
        try {
            whitelistFile.createNewFile();
        }
        catch (IOException | SecurityException e) {
            log.warn((Object)String.format("Couldn't create home directory whitelist file: %s", whitelistFile.getPath()), (Throwable)e);
        }
    }

    @VisibleForTesting
    @NotNull
    File getHomeDirectoryClassWhitelistFile() {
        return new File(this.bootstrapManager.getConfigDirectory(), "serialization-whitelist.list");
    }

    public void stop() {
        try {
            log.info((Object)"Stopping Bamboo server...");
            this.agentManager.stopLocalAgents();
            this.stopJobScheduler();
            if (this.bambooSmackClient != null) {
                this.bambooSmackClient.disconnect();
            }
            PersisterFactory.getInstance().stop();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to stop server", e);
        }
    }

    public void prepareForRestart() throws Exception {
        try {
            log.info((Object)"Stopping Bamboo server...");
            this.agentManager.stopLocalAgents();
            this.remoteAgentManager.stopConnectors();
            this.scheduler.standby();
            if (this.bambooSmackClient != null) {
                this.bambooSmackClient.disconnect();
            }
            PersisterFactory.getInstance().stop();
            this.pluginManager.getEnabledPlugins().stream().map(Plugin::getKey).forEach(arg_0 -> ((BambooPluginManager)this.pluginManager).disablePluginWithoutPersisting(arg_0));
            this.pluginManager.shutdown();
            log.info((Object)"Restarting Bamboo server...");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to stop server", e);
        }
    }

    public void restartComponentsFollowingConfigurationChange() {
        try {
            Persister persister = PersisterFactory.getInstance();
            persister.reload();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to reload components following a configuration change", e);
        }
    }

    public Collection<ErrorDetails> getErrorMessages() {
        return this.errorHandler.getAllErrors();
    }

    public Collection<ErrorDetails> getErrorMessages(@NotNull PlanKey planKey) {
        return this.errorHandler.getErrors((Key)planKey);
    }

    public Collection<ErrorDetails> getElasticErrorMessages() {
        return this.errorHandler.getElasticErrors();
    }

    public Collection<ErrorDetails> getErrorMessagesByAgentId(@NotNull Long agentId) {
        return this.errorHandler.getErrorsByAgentId(agentId);
    }

    public void clearErrorMessages() {
        this.errorHandler.clear();
    }

    public void removeBuildErrorFromLog(String buildKey, int errorNumber) {
        this.errorHandler.removeError(buildKey, errorNumber);
    }

    public ErrorDetails getBuildErrorDetails(String buildKey, int errorNumber) {
        return this.errorHandler.getErrorDetails(buildKey, errorNumber);
    }

    public Persister getDefaultPersister() {
        return this.persister;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public AdministrationConfiguration getAdministrationConfiguration() {
        Persister defaultPersister = this.getDefaultPersister();
        return defaultPersister.getAdministrationConfiguration();
    }

    public static BambooContainer getBambooContainer() {
        return BAMBOO_CONTAINER;
    }
}

