/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.container;

import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class ShutdownEnforcer {
    private static final Logger log = Logger.getLogger(ShutdownEnforcer.class);
    private static final Logger lifecycleLog = Logger.getLogger((String)"com.atlassian.bamboo.lifecycle");
    private static final int LAST_RESORT_TERMINATION_DELAY_SECONDS = 15;

    public void destroy() {
        log.info((Object)"Container being shut down: starting last-resort termination thread.");
        this.startLastResortTerminationThread();
    }

    private void startLastResortTerminationThread() {
        Thread terminationThread = new Thread("LastResortTerminationThread"){

            @Override
            public void run() {
                try {
                    TimeUnit.SECONDS.sleep(15L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                int nonDeamonThreads = ShutdownEnforcer.this.logNonDaemonThreads();
                lifecycleLog.info((Object)"*******************************");
                lifecycleLog.info((Object)"*  Bamboo has been shut down  *");
                lifecycleLog.info((Object)"*******************************");
                if (nonDeamonThreads != 0) {
                    log.warn((Object)"Calling System.exit()");
                }
                try {
                    System.exit(nonDeamonThreads);
                }
                catch (RuntimeException e) {
                    log.warn((Object)"Unable to call System.exit :-(", (Throwable)e);
                }
            }
        };
        terminationThread.setDaemon(true);
        terminationThread.start();
    }

    private int logNonDaemonThreads() {
        Thread thisThread = Thread.currentThread();
        ThreadGroup root = thisThread.getThreadGroup();
        while (root.getParent() != null) {
            root = root.getParent();
        }
        Thread[] threads = new Thread[root.activeCount() * 2];
        int numThreads = root.enumerate(threads, true);
        int nonDaemonThreadCount = 0;
        for (int i = 0; i < numThreads; ++i) {
            Thread thread = threads[i];
            if (thread.isDaemon() || thread == thisThread || thread.getName().contains("DestroyJavaVM")) continue;
            log.warn((Object)("Shutting down Bamboo despite the fact that a non-daemon thread " + thread + " is still running."));
            ++nonDaemonThreadCount;
        }
        return nonDaemonThreadCount;
    }
}

