/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.container.startup;

import com.atlassian.bamboo.security.trustedapplications.BambooCurrentApplication;
import com.atlassian.bamboo.security.trustedapplications.BambooTrustedApplicationDao;
import com.atlassian.bamboo.security.trustedapplications.KeyUtils;
import com.atlassian.security.auth.trustedapps.EncryptionProvider;
import java.security.KeyPair;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class InitialiseTrustedAppsOnStartup
implements Runnable {
    private static final Logger log = Logger.getLogger(InitialiseTrustedAppsOnStartup.class);
    @Inject
    private EncryptionProvider encryptionProvider;
    @Inject
    private BambooTrustedApplicationDao trustedAppsDao;

    @Override
    public void run() {
        if (this.trustedAppsDao.getCurrentApplication() != null) {
            return;
        }
        log.info((Object)"Generating a new Trusted Apps key pair.");
        KeyPair keyPair = KeyUtils.generateNewKeyPair((EncryptionProvider)this.encryptionProvider);
        BambooCurrentApplication currentApp = new BambooCurrentApplication(this.encryptionProvider.generateUID(), keyPair);
        this.trustedAppsDao.save(currentApp);
    }
}

