/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.container.startup;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildExecutionManager;
import com.atlassian.bamboo.build.CurrentlyBuildingContainer;
import com.atlassian.bamboo.build.fileserver.DefaultBuildDirectoryManager;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.chains.ChainExecutionManager;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.container.startup.PendingBuildResultsStateRestoration;
import com.atlassian.bamboo.container.startup.PendingBuildResultsStateRestorationJob;
import com.atlassian.bamboo.event.ChainAbandonedEvent;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.PlanResultKeyProvider;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.utils.BambooFiles;
import com.atlassian.bamboo.utils.BambooPathUtils;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.event.api.EventPublisher;
import com.google.common.collect.Sets;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;

public class PendingBuildResultsStateRestorationImpl
implements PendingBuildResultsStateRestoration {
    private static final Logger log = Logger.getLogger(PendingBuildResultsStateRestorationImpl.class);
    private static final boolean shouldRestoreState = !SystemProperty.BAMBOO_IGNORE_SERVER_STATE_ON_RESTART.getTypedValue();
    private final ResultsSummaryManager resultsSummaryManager;
    private final CurrentlyBuildingContainer currentlyBuildingContainer;
    private final ChainExecutionManager chainExecutionManager;
    private final BuildExecutionManager buildExecutionManager;
    private final EventPublisher eventPublisher;
    private final Scheduler scheduler;
    @Inject
    private DefaultBuildDirectoryManager buildDirectoryManager;

    @Inject
    public PendingBuildResultsStateRestorationImpl(ResultsSummaryManager resultsSummaryManager, CurrentlyBuildingContainer currentlyBuildingContainer, ChainExecutionManager chainExecutionManager, BuildExecutionManager buildExecutionManager, EventPublisher eventPublisher, Scheduler scheduler) {
        this.resultsSummaryManager = resultsSummaryManager;
        this.currentlyBuildingContainer = currentlyBuildingContainer;
        this.chainExecutionManager = chainExecutionManager;
        this.buildExecutionManager = buildExecutionManager;
        this.eventPublisher = eventPublisher;
        this.scheduler = scheduler;
    }

    @Override
    public Set<ResultKey> restoreState() {
        Set<ResultKey> restoredBuilds;
        List<ChainResultsSummary> chainsInProgress = Stream.of(this.resultsSummaryManager.getAllPendingResultSummaries(ChainResultsSummary.class), this.resultsSummaryManager.getAllQueuedResultSummaries(ChainResultsSummary.class), this.resultsSummaryManager.getAllInProgressResultSummaries(ChainResultsSummary.class)).flatMap(Collection::stream).collect(Collectors.toList());
        Set runningJobsFromChainState = Collections.emptySet();
        Set<PlanResultKey> restoredChainKeys = Collections.emptySet();
        if (shouldRestoreState) {
            Set resultKeysOfChainsInProgress = chainsInProgress.stream().map(PlanResultKeyProvider::getPlanResultKey).collect(Collectors.toSet());
            runningJobsFromChainState = this.chainExecutionManager.restoreState(resultKeysOfChainsInProgress);
            restoredChainKeys = runningJobsFromChainState.stream().map(PlanKeys::getChainResultKey).collect(Collectors.toSet());
            this.cleanUpMergeWorkspaces(restoredChainKeys);
        }
        List buildsInProgress = Stream.of(this.resultsSummaryManager.getAllPendingResultSummaries(BuildResultsSummary.class), this.resultsSummaryManager.getAllQueuedResultSummaries(BuildResultsSummary.class), this.resultsSummaryManager.getAllInProgressResultSummaries(BuildResultsSummary.class)).flatMap(Collection::stream).collect(Collectors.toList());
        if (shouldRestoreState) {
            Set<PlanResultKey> resultKeysOfBuildsInProgress = buildsInProgress.stream().map(PlanResultKeyProvider::getPlanResultKey).collect(Collectors.toSet());
            log.info((Object)("Restoring state of " + resultKeysOfBuildsInProgress));
            restoredBuilds = this.currentlyBuildingContainer.restoreState(resultKeysOfBuildsInProgress);
        } else {
            restoredBuilds = Collections.emptySet();
        }
        if (!SystemProperty.DISABLE_RESULTS_CLEANUP_ON_STARTUP.getTypedValue()) {
            if (shouldRestoreState || !SystemProperty.DEFER_RESULTS_CLEANUP_ON_STARTUP.getTypedValue()) {
                log.info((Object)"Cleaning up chains results");
                this.transitionChainResultsToNotBuilt(chainsInProgress, restoredChainKeys);
                log.info((Object)"Cleaning up build results");
                this.transitionBuildResultsToNotBuilt(buildsInProgress, runningJobsFromChainState, restoredBuilds);
            } else {
                log.info((Object)"Deferring chains and builds results cleanup");
                JobKey jobKey = JobKey.jobKey((String)"pendingBuildResultsStateRestorationJob", (String)"DEFAULT");
                JobDetail job = JobBuilder.newJob(PendingBuildResultsStateRestorationJob.class).withIdentity(jobKey).build();
                JobDataMap jobParameters = job.getJobDataMap();
                jobParameters.put("chainsInProgress", chainsInProgress);
                jobParameters.put("buildsInProgress", buildsInProgress);
                try {
                    this.scheduler.addJob(job, true, true);
                    this.scheduler.triggerJob(jobKey);
                }
                catch (SchedulerException e) {
                    throw new RuntimeException(e);
                }
                log.info((Object)"Submitted deferred builds status cleanup. Proceeding with startup now");
            }
        }
        return Sets.intersection(restoredBuilds, (Set)runningJobsFromChainState);
    }

    @Override
    public void restoreStateAsync(List<ChainResultsSummary> chainsInProgress, List<BuildResultsSummary> buildsInProgress) {
        if (!shouldRestoreState) {
            Set<ResultKey> restoredBuilds = Collections.emptySet();
            Set<PlanResultKey> restoredChainKeys = Collections.emptySet();
            Set<PlanResultKey> runningJobsFromChainState = Collections.emptySet();
            log.info((Object)"Cleaning up chains results");
            this.transitionChainResultsToNotBuilt(chainsInProgress, restoredChainKeys);
            log.info((Object)"Cleaning up build results");
            this.transitionBuildResultsToNotBuilt(buildsInProgress, runningJobsFromChainState, restoredBuilds);
        }
    }

    private void cleanUpMergeWorkspaces(Collection<PlanResultKey> restoredChainKeys) {
        File serverSideWorkingDir = this.buildDirectoryManager.getServerSideTaskWorkingDirectory();
        String[] planWorkspaceNames = serverSideWorkingDir.list();
        if (planWorkspaceNames == null) {
            return;
        }
        log.info((Object)("Cleaning up merge workspaces in " + serverSideWorkingDir));
        for (String planWorkspaceName : planWorkspaceNames) {
            Path planWorkspace = serverSideWorkingDir.toPath().resolve(planWorkspaceName);
            try {
                PlanResultKey planResultKey = PlanKeys.getPlanResultKey((String)planWorkspaceName);
                if (!PlanKeys.isChainKey((PlanKey)planResultKey.getPlanKey()) || restoredChainKeys.contains(planResultKey)) continue;
                Path mergeWorkspace = planWorkspace.resolve("mergeWorkspace");
                BambooPathUtils.deleteQuietly((Path)mergeWorkspace);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (BambooFiles.deleteQuietly((Path)planWorkspace)) continue;
            log.warn((Object)("Leaving " + planWorkspace));
        }
    }

    private void transitionChainResultsToNotBuilt(Collection<ChainResultsSummary> chainResults, Collection<PlanResultKey> restoredChainKeys) {
        log.info((Object)("There are " + chainResults.size() + " possibly stale chain results"));
        if (chainResults.isEmpty()) {
            return;
        }
        Set staleChainResults = chainResults.stream().filter(c -> !restoredChainKeys.contains(c.getPlanResultKey())).collect(Collectors.toSet());
        if (staleChainResults.isEmpty()) {
            log.info((Object)"All inflight chains were restored");
            return;
        }
        Level logLevel = shouldRestoreState ? Level.INFO : Level.DEBUG;
        log.info((Object)("Cleaning up " + staleChainResults.size() + " stale chain results"));
        for (ChainResultsSummary chainResult : staleChainResults) {
            log.log((Priority)logLevel, (Object)("Changing " + chainResult.getPlanResultKey() + " state to " + LifeCycleState.NOT_BUILT));
            this.resultsSummaryManager.cleanPendingLifeCycleStateNewTx(chainResult.getPlanResultKey());
            this.eventPublisher.publish((Object)new ChainAbandonedEvent((Object)this, chainResult.getPlanResultKey()));
        }
        log.info((Object)"Chain results cleaned up");
    }

    private void transitionBuildResultsToNotBuilt(Collection<? extends ResultsSummary> resultsSummaries, Set<PlanResultKey> runningJobsFromChainState, Set<ResultKey> restoredBuilds) {
        log.info((Object)("There are " + resultsSummaries.size() + " possibly stale build results"));
        if (resultsSummaries.isEmpty()) {
            return;
        }
        List staleBuildResults = resultsSummaries.stream().filter(rs -> {
            boolean wasRestored = restoredBuilds.contains(rs.getPlanResultKey());
            boolean isPending = LifeCycleState.isPending((LifeCycleState)rs.getLifeCycleState());
            boolean isRunningAccordingToChainState = runningJobsFromChainState.contains(rs.getPlanResultKey());
            return !wasRestored && !isPending || !isRunningAccordingToChainState;
        }).collect(Collectors.toList());
        if (staleBuildResults.isEmpty()) {
            log.info((Object)"All inflight builds were restored");
            return;
        }
        Level logLevel = shouldRestoreState ? Level.INFO : Level.DEBUG;
        log.info((Object)("Cleaning up " + staleBuildResults.size() + " stale build results"));
        for (ResultsSummary resultsSummary : staleBuildResults) {
            log.log((Priority)logLevel, (Object)("Changing " + resultsSummary.getPlanResultKey() + " state to " + LifeCycleState.NOT_BUILT));
            this.buildExecutionManager.finishBuildNewTx(resultsSummary.getPlanResultKey(), false);
        }
    }
}

