/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.core;

import com.atlassian.bamboo.chains.ChainStageDao;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.core.BambooEntityOidService;
import com.atlassian.bamboo.core.BambooEntityType;
import com.atlassian.bamboo.credentials.CredentialsDao;
import com.atlassian.bamboo.deployments.projects.persistence.DeploymentProjectDao;
import com.atlassian.bamboo.fieldvalue.TaskConfigurationUtils;
import com.atlassian.bamboo.oid.IdGeneratorDao;
import com.atlassian.bamboo.plan.PlanDao;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionDao;
import com.atlassian.bamboo.project.ProjectDao;
import com.atlassian.bamboo.repository.RepositoryDefinitionDao;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.common.collect.UnmodifiableIterator;
import io.atlassian.util.concurrent.ManagedLock;
import io.atlassian.util.concurrent.ManagedLocks;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
public class BambooEntityOidServiceImpl
implements BambooEntityOidService {
    private static final Logger log = Logger.getLogger(BambooEntityOidServiceImpl.class);
    private final Function<BambooEntityType, ManagedLock> lockFactory = ManagedLocks.weakManagedLockFactory();
    private final Map<BambooEntityType, Iterator<Long>> entityIdsPool = new ConcurrentHashMap<BambooEntityType, Iterator<Long>>(BambooEntityType.values().length, 1.0f);
    @Inject
    private BootstrapManager bootstrapManager;
    @Inject
    private ChainStageDao chainStageDao;
    @Inject
    private IdGeneratorDao idGeneratorDao;
    @Inject
    private PlanDao planDao;
    @Inject
    private ProjectDao projectDao;
    @Inject
    private RepositoryDefinitionDao repositoryDefinitionDao;
    @Inject
    private ArtifactDefinitionDao artifactDefinitionDao;
    @Inject
    private CredentialsDao credentialsDao;
    @Inject
    private DeploymentProjectDao deploymentProjectDao;

    @NotNull
    public BambooEntityOid nextOid(@NotNull BambooEntityType entityType) {
        long entityId = (Long)this.lockFactory.apply(entityType).withLock(() -> {
            UnmodifiableIterator idsPool = this.entityIdsPool.getOrDefault(entityType, Collections.emptyIterator());
            if (!idsPool.hasNext()) {
                Range<Long> nextIdRange = this.idGeneratorDao.nextIdRange(entityType);
                idsPool = ContiguousSet.create(nextIdRange, (DiscreteDomain)DiscreteDomain.longs()).iterator();
                this.entityIdsPool.put(entityType, (Iterator<Long>)idsPool);
            }
            return (Long)idsPool.next();
        });
        return BambooEntityOid.create((int)this.bootstrapManager.getServerKey(), (BambooEntityType)entityType, (long)entityId);
    }

    public void resetOidPool(@NotNull BambooEntityType entityType) {
        this.lockFactory.apply(entityType).withLock(() -> {
            BambooEntityOid maxExistingOid;
            int serverKey = this.bootstrapManager.getServerKey();
            switch (entityType) {
                case STAGE: {
                    maxExistingOid = this.chainStageDao.getMaxStageOid(serverKey);
                    break;
                }
                case REPOSITORY: {
                    maxExistingOid = this.repositoryDefinitionDao.getMaxRepositoryOid(serverKey);
                    break;
                }
                case CHAIN: 
                case JOB: 
                case CHAIN_BRANCH: 
                case JOB_BRANCH: {
                    maxExistingOid = this.planDao.getMaxPlanOid(serverKey, entityType);
                    break;
                }
                case TASK: {
                    maxExistingOid = TaskConfigurationUtils.getMaxTaskOid(serverKey);
                    break;
                }
                case PROJECT: {
                    maxExistingOid = this.projectDao.getMaxProjectOid(serverKey);
                    break;
                }
                case ARTIFACT_DEFINITION: {
                    maxExistingOid = this.artifactDefinitionDao.getMaxArtifactDefinitionOid(serverKey);
                    break;
                }
                case SHARED_CREDENTIAL: {
                    maxExistingOid = this.credentialsDao.getMaxCredentialOid(serverKey);
                    break;
                }
                case DEPLOYMENT_PROJECT: {
                    maxExistingOid = this.deploymentProjectDao.getMaxDeploymentProjectOid(serverKey);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown entity type: " + entityType);
                }
            }
            if (maxExistingOid != null) {
                log.info((Object)("Resetting pool of OIDs for entity type " + entityType));
                this.idGeneratorDao.resetId(maxExistingOid);
                this.entityIdsPool.remove(entityType);
            } else {
                log.debug((Object)String.format("Reset of OID pool for entity type %s requested, but there are no entities of that type - no action", entityType));
            }
        });
    }
}

