/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.core;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.LimitedConcurrencyCaller;
import com.atlassian.bamboo.core.ScopedExclusionService;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.util.BambooHibernateUtils;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import java.util.concurrent.Callable;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.jetbrains.annotations.Nullable;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class ScopedExclusionServiceHelper {
    private static final Supplier<HibernateTemplate> hibernateTemplate = ComponentAccessor.HIBERNATE_TEMPLATE;

    private ScopedExclusionServiceHelper() {
    }

    public static <V, E extends Throwable> V withLockedKeyIdentifiedEntity(ScopedExclusionService exclusionService, Key key, ScopedExclusionService.ExclusiveFunction<Key, V, E> functor) throws E {
        return (V)exclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.KEY, (Object)key, functor);
    }

    public static <V, E extends Throwable> V withLockedIdIdentifiedEntity(ScopedExclusionService exclusionService, long id, ScopedExclusionService.ExclusiveFunction<Long, V, E> functor) throws E {
        return (V)exclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.ID, (Object)id, functor);
    }

    public static <V, E extends Throwable> V withLockedJob(ScopedExclusionService exclusionService, PlanKey planKey, ScopedExclusionService.ExclusiveFunction<PlanKey, V, E> functor) throws E {
        return (V)exclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.JOB_KEY, (Object)planKey, functor);
    }

    public static <V, E extends Throwable> V withLockedChain(ScopedExclusionService exclusionService, PlanKey planKey, ScopedExclusionService.ExclusiveFunction<PlanKey, V, E> functor) throws E {
        return (V)exclusionService.withLock((Enum)ScopedExclusionService.ExclusionScopeType.CHAIN_KEY, (Object)planKey, functor);
    }

    public static <S, V> ScopedExclusionService.ExclusiveFunction<S, V, RuntimeException> clearSession(final ScopedExclusionService.ExclusiveFunction<S, V, RuntimeException> function) {
        return new ScopedExclusionService.ExclusiveFunction<S, V, RuntimeException>(){

            public V apply(final @Nullable S input) {
                return ((HibernateTemplate)hibernateTemplate.get()).execute(new HibernateCallback<V>(){

                    public V doInHibernate(Session session) throws HibernateException {
                        BambooHibernateUtils.flushIfNeeded(session);
                        session.clear();
                        return function.apply(input);
                    }
                });
            }
        };
    }

    public static <S, V> ScopedExclusionService.ExclusiveFunction<S, V, RuntimeException> adapt(Function<S, V> function) {
        return arg_0 -> function.apply(arg_0);
    }

    public static <S, V> ScopedExclusionService.ExclusiveFunction<S, V, RuntimeException> adapt(Supplier<V> supplier) {
        return input -> supplier.get();
    }

    @Deprecated
    public static <S, V> ScopedExclusionService.ExclusiveFunction<S, V, RuntimeException> adapt(com.atlassian.util.concurrent.Supplier<V> supplier) {
        return input -> supplier.get();
    }

    public static <S, V> ScopedExclusionService.ExclusiveFunction<S, V, RuntimeException> adapt(java.util.function.Supplier<V> supplier) {
        return input -> supplier.get();
    }

    public static <S> ScopedExclusionService.ExclusiveFunction<S, Void, RuntimeException> adapt(final Runnable runnable) {
        return new ScopedExclusionService.ExclusiveFunction<S, Void, RuntimeException>(){

            @Nullable
            public Void apply(S input) {
                runnable.run();
                return null;
            }
        };
    }

    public static <S> ScopedExclusionService.ExclusiveFunction<S, Void, Exception> adapt(final Callable<S> callable) {
        return new ScopedExclusionService.ExclusiveFunction<S, Void, Exception>(){

            @Nullable
            public Void apply(S input) throws Exception {
                callable.call();
                return null;
            }
        };
    }

    public static <S, V, E extends Exception> ScopedExclusionService.ExclusiveFunction<S, V, E> adapt(final LimitedConcurrencyCaller.Callable<V, E> callable) {
        return new ScopedExclusionService.ExclusiveFunction<S, V, E>(){

            @Nullable
            public V apply(S input) throws Exception {
                return callable.call();
            }
        };
    }
}

