/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.core;

import com.atlassian.bamboo.core.ScopedExclusionService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.atlassian.fugue.Either;
import java.util.Optional;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopedExclusionServiceImpl
implements ScopedExclusionService {
    private final LoadingCache<LockStripe, ReadWriteLock> locks = ScopedExclusionServiceImpl.weakReadWriteLockFactory();

    public static <T> LoadingCache<T, ReadWriteLock> weakReadWriteLockFactory() {
        LoadingCache locks = CacheBuilder.newBuilder().weakValues().build(new CacheLoader<T, ReadWriteLock>(){

            public ReadWriteLock load(T key) throws Exception {
                return new ReentrantReadWriteLock();
            }
        });
        return locks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S, V, E extends Throwable, F extends Throwable> V withNewLockedObject(@NotNull Enum<?> generationScopeType, @Nullable S objectToLockDuringGeneration, @Nullable Enum<?> generatedObjectScope, @NotNull ScopedExclusionService.GeneratorCallable<S, F> objectGenerator, @NotNull ScopedExclusionService.ExclusiveFunction<S, V, E> function) throws E, F {
        Object generatedObject;
        ReadWriteLock generatedObjectLock;
        if (generatedObjectScope == null) {
            generatedObjectScope = generationScopeType;
        }
        ReadWriteLock generationLock = this.getLock(generationScopeType, objectToLockDuringGeneration);
        generationLock.writeLock().lock();
        try {
            while (!(generatedObjectLock = this.getLock(generatedObjectScope, generatedObject = objectGenerator.call())).writeLock().tryLock()) {
            }
        }
        finally {
            generationLock.writeLock().unlock();
        }
        try {
            Object object = function.apply(generatedObject);
            return (V)object;
        }
        finally {
            generatedObjectLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S, V, E extends Throwable> V withLock(@NotNull Enum<?> scopeType, @NotNull S objectToLock, @NotNull ScopedExclusionService.ExclusiveFunction<S, V, E> function) throws E {
        ReadWriteLock nameLock = this.getLock(scopeType, objectToLock);
        nameLock.writeLock().lock();
        try {
            Object object = function.apply(objectToLock);
            return (V)object;
        }
        finally {
            nameLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S, V, E extends Throwable> Either<Boolean, Optional<V>> tryWithLock(@NotNull Enum<?> scopeType, @NotNull S objectToLock, @NotNull ScopedExclusionService.ExclusiveFunction<S, V, E> function) throws E {
        ReadWriteLock nameLock = this.getLock(scopeType, objectToLock);
        if (nameLock.writeLock().tryLock()) {
            try {
                Either either = Either.right(Optional.ofNullable(function.apply(objectToLock)));
                return either;
            }
            finally {
                nameLock.writeLock().unlock();
            }
        }
        return Either.left((Object)false);
    }

    private ReadWriteLock getLock(@NotNull Enum<?> type, @Nullable Object scope) {
        return (ReadWriteLock)this.locks.getUnchecked((Object)new LockStripe(type, scope));
    }

    private ReadWriteLock getLock(@NotNull Enum<?> type) {
        return (ReadWriteLock)this.locks.getUnchecked((Object)new LockStripe(type));
    }

    private static class LockStripe {
        private final Enum<?> type;
        private final Object scope;

        public LockStripe(@NotNull Enum<?> type, @Nullable Object scope) {
            this.type = type;
            this.scope = scope;
        }

        public LockStripe(@NotNull Enum<?> type) {
            this(type, null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LockStripe that = (LockStripe)o;
            if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) {
                return false;
            }
            return this.type.equals(that.type);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "LockStripe{type=" + this.type + ", scope=" + this.scope + '}';
        }
    }
}

