/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.credentials;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.credentials.CredentialType;
import com.atlassian.bamboo.credentials.CredentialTypeModuleDescriptor;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.opensymphony.xwork2.TextProvider;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCredentialType
implements CredentialType {
    public static final String CFG_CREDENTIALS_NAME = "credentialsName";
    protected TextProvider textProvider;

    public void init(@NotNull CredentialTypeModuleDescriptor moduleDescriptor) {
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull CredentialsData previousCredentialsData) {
        context.put(CFG_CREDENTIALS_NAME, previousCredentialsData.getName());
    }

    public void validate(@NotNull ActionParametersMap params, @Nullable CredentialsData previousCredentialsData, @NotNull ErrorCollection errorCollection) {
        String credentialsName = params.getString(CFG_CREDENTIALS_NAME);
        if (StringUtils.isBlank((CharSequence)credentialsName)) {
            errorCollection.addError(CFG_CREDENTIALS_NAME, this.textProvider.getText("credentials.name.empty"));
        } else if (credentialsName.length() > 255) {
            errorCollection.addError(CFG_CREDENTIALS_NAME, this.textProvider.getText("credentials.name.tooLong"));
        }
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    @NotNull
    public Map<String, String> getCredentialsConfigurationMap(@NotNull CredentialsData credentialsData) {
        return Collections.emptyMap();
    }

    @NotNull
    public Map<String, String> generateCredentialsConfigMap(@NotNull Map<String, String> params) throws WebValidationException {
        return Collections.emptyMap();
    }
}

