/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.credentials;

import com.atlassian.bamboo.credentials.CredentialType;
import com.atlassian.bamboo.credentials.CredentialTypeExporter;
import com.atlassian.bamboo.credentials.CredentialTypeModuleDescriptor;
import com.atlassian.bamboo.credentials.DefaultCredentialTypeExporter;
import com.atlassian.bamboo.plugin.descriptor.AbstractBambooModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import io.atlassian.util.concurrent.ResettableLazyReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.jetbrains.annotations.NotNull;

public class CredentialTypeModuleDescriptorImpl
extends AbstractBambooModuleDescriptor<CredentialType>
implements CredentialTypeModuleDescriptor {
    private static final Logger log = Logger.getLogger(CredentialTypeModuleDescriptorImpl.class);
    private static final String EXPORTER = "exporter";
    private static final String CLASS = "class";
    private String exporterClassName;
    private final ResettableLazyReference<CredentialTypeExporter> exporter = new ResettableLazyReference<CredentialTypeExporter>(){

        protected CredentialTypeExporter create() throws Exception {
            return (CredentialTypeExporter)CredentialTypeModuleDescriptorImpl.this.instantiateSubmodule(CredentialTypeModuleDescriptorImpl.EXPORTER, CredentialTypeModuleDescriptorImpl.this.exporterClassName, DefaultCredentialTypeExporter.class);
        }
    };

    public CredentialTypeModuleDescriptorImpl(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(@NotNull Plugin plugin, @NotNull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.exporterClassName = this.prepareSubModuleConfiguration(element, this.exporter, EXPORTER);
    }

    private String prepareSubModuleConfiguration(Element element, ResettableLazyReference<?> reference, String elementName) {
        if (element.element(elementName) != null) {
            Element configuration = element.element(elementName);
            String clazz = configuration.attributeValue(CLASS);
            if (StringUtils.isBlank((CharSequence)clazz)) {
                log.warn((Object)("Credential Type Module (" + this.getKey() + ") of plugin " + this.plugin.getKey() + " contains an incorrectly configured '" + elementName + "' element. Please use the 'class' attribute to define your '" + elementName + "' class"));
            }
            reference.reset();
            return clazz;
        }
        return null;
    }

    public void enabled() {
        super.enabled();
        this.exporter.reset();
    }

    @Override
    public void disabled() {
        super.disabled();
        this.exporter.reset();
    }

    @NotNull
    public CredentialTypeExporter getExporter() {
        return (CredentialTypeExporter)this.exporter.get();
    }
}

