/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.credentials;

import com.atlassian.bamboo.credentials.ConfigurableSharedCredentialDepender;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.credentials.SharedCredentialDepender;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class Credentials {
    private Credentials() {
    }

    public static <T> Iterable<CredentialsData> getAllSharedCredentials(@NotNull Iterable<T> sharedCredentialTypes, @NotNull CredentialsAccessor credentialsAccessor, @NotNull Function<T, SharedCredentialDepender> createDependerFunction) {
        HashSet<Long> sharedCredentialIds = new HashSet<Long>();
        for (T sharedCredentialType : sharedCredentialTypes) {
            SharedCredentialDepender sharedCredentialDepender = (SharedCredentialDepender)createDependerFunction.apply(sharedCredentialType);
            if (sharedCredentialDepender == null) continue;
            Iterables.addAll(sharedCredentialIds, (Iterable)sharedCredentialDepender.getSharedCredentialIds());
        }
        return Credentials.fromIds(sharedCredentialIds, credentialsAccessor);
    }

    private static Iterable<CredentialsData> fromIds(Set<Long> sharedCredentialIds, CredentialsAccessor credentialsAccessor) {
        return sharedCredentialIds.stream().map(arg_0 -> ((CredentialsAccessor)credentialsAccessor).getCredentials(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T> Iterable<CredentialsData> getAllSharedCredentials(@NotNull Iterable<T> sharedCredentialTypes, @NotNull CredentialsAccessor credentialsAccessor, @NotNull java.util.function.Function<T, ConfigurableSharedCredentialDepender> createDependerFunction, @NotNull java.util.function.Function<T, Map<String, String>> createConfigFunction) {
        HashSet<Long> sharedCredentialIds = new HashSet<Long>();
        for (T sharedCredentialType : sharedCredentialTypes) {
            ConfigurableSharedCredentialDepender sharedCredentialDepender = createDependerFunction.apply(sharedCredentialType);
            Map<String, String> config = createConfigFunction.apply(sharedCredentialType);
            if (sharedCredentialDepender == null) continue;
            Iterables.addAll(sharedCredentialIds, (Iterable)sharedCredentialDepender.getSharedCredentialIds(config));
        }
        return Credentials.fromIds(sharedCredentialIds, credentialsAccessor);
    }

    public static Iterable<CredentialsData> getAllSharedCredentials(@NotNull Iterable<? extends VcsRepositoryData> repositories, @NotNull VcsRepositoryManager vcsRepositoryManager, @NotNull CredentialsAccessor credentialsAccessor) {
        HashSet<Long> sharedCredentialIds = new HashSet<Long>();
        for (VcsRepositoryData vcsRepositoryData : repositories) {
            VcsRepositoryModuleDescriptor moduleDescriptor = vcsRepositoryManager.getVcsRepositoryModuleDescriptor(vcsRepositoryData.getPluginKey());
            if (moduleDescriptor == null) continue;
            Iterables.addAll(sharedCredentialIds, (Iterable)moduleDescriptor.getVcsLocationConfigurator().getSharedCredentialsIds(vcsRepositoryData.getVcsLocation()));
        }
        return Credentials.fromIds(sharedCredentialIds, credentialsAccessor);
    }

    @NotNull
    public static String configToXml(@NotNull Map<String, String> credentialsConfig) {
        XMLConfiguration xmlConfiguration = ConfigUtils.newConfiguration();
        for (Map.Entry<String, String> configEntry : credentialsConfig.entrySet()) {
            if (!StringUtils.isNotBlank((CharSequence)configEntry.getValue())) continue;
            xmlConfiguration.setProperty(configEntry.getKey(), (Object)configEntry.getValue());
        }
        return ConfigUtils.asXmlString((XMLConfiguration)xmlConfiguration);
    }

    @NotNull
    public static Map<String, String> xmlToConfig(@NotNull String xml) {
        if (StringUtils.isBlank((CharSequence)xml)) {
            return new HashMap<String, String>();
        }
        return ConfigUtils.asMap((Configuration)ConfigUtils.getXmlConfigFromXmlString((String)xml), null);
    }
}

