/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.credentials;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.core.BambooEntityWithOid;
import com.atlassian.bamboo.credentials.Credentials;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.credentials.MutableCredentialsData;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="CREDENTIALS")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
@Internal
public class CredentialsDataEntity
extends BambooEntityWithOid
implements MutableCredentialsData {
    private String pluginKey;
    protected String name;
    private String xml;

    public CredentialsDataEntity() {
    }

    public CredentialsDataEntity(String pluginKey, String name, Map<String, String> configuration, @Nullable BambooEntityOid oid) {
        this(pluginKey, name, Credentials.configToXml(configuration), oid);
    }

    public CredentialsDataEntity(String pluginKey, String name, String xml) {
        this(pluginKey, name, xml, null);
    }

    public CredentialsDataEntity(String pluginKey, String name, String xml, @Nullable BambooEntityOid oid) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)xml) ? 1 : 0) != 0);
        this.pluginKey = pluginKey;
        this.name = name;
        this.xml = xml;
        if (oid != null) {
            this.setOid(oid);
        }
    }

    public CredentialsDataEntity(@NotNull CredentialsData other) {
        this(other.getPluginKey(), other.getName(), other instanceof MutableCredentialsData ? ((MutableCredentialsData)other).getXml() : Credentials.configToXml(other.getConfiguration()), other.getOid());
        if (other.getId() > 0L) {
            this.setId(other.getId());
        }
    }

    public String getPluginKey() {
        return this.pluginKey;
    }

    public void setPluginKey(String pluginKey) {
        this.pluginKey = pluginKey;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @NotNull
    public String getXml() {
        return this.xml;
    }

    public void setXml(@NotNull String xml) {
        this.xml = xml;
    }

    @NotNull
    public Map<String, String> getConfiguration() {
        return Credentials.xmlToConfig(this.xml);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.pluginKey, this.name, this.xml});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CredentialsDataEntity other = (CredentialsDataEntity)((Object)obj);
        return Objects.equal((Object)this.pluginKey, (Object)other.pluginKey) && Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.xml, (Object)other.xml);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).addValue(this.getId()).addValue((Object)this.pluginKey).addValue((Object)this.name).toString();
    }
}

