/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.credentials;

import com.atlassian.bamboo.collections.message.FinalHashMap;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CredentialsDataImpl
implements CredentialsData {
    private final long id;
    private final BambooEntityOid oid;
    private final String pluginKey;
    private final String name;
    private final FinalHashMap<String, String> configuration;

    public CredentialsDataImpl(@NotNull CredentialsData other) {
        this.id = other.getId();
        this.oid = other.getOid();
        this.pluginKey = other.getPluginKey();
        this.name = other.getName();
        this.configuration = new FinalHashMap(other.getConfiguration());
    }

    public long getId() {
        return this.id;
    }

    public BambooEntityOid getOid() {
        return this.oid;
    }

    public String getPluginKey() {
        return this.pluginKey;
    }

    public String getName() {
        return this.name;
    }

    @NotNull
    public Map<String, String> getConfiguration() {
        return Collections.unmodifiableMap(this.configuration);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.pluginKey, this.name, this.configuration});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CredentialsDataImpl other = (CredentialsDataImpl)obj;
        return Objects.equal((Object)this.pluginKey, (Object)other.pluginKey) && Objects.equal((Object)this.name, (Object)other.name) && Objects.equal(this.configuration, other.configuration);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue(this.getId()).addValue((Object)this.pluginKey).addValue((Object)this.name).toString();
    }
}

