/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.credentials;

import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.credentials.CredentialTypeExporter;
import com.atlassian.bamboo.credentials.CredentialTypeModuleDescriptor;
import com.atlassian.bamboo.credentials.Credentials;
import com.atlassian.bamboo.credentials.CredentialsDao;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.credentials.CredentialsDataEntity;
import com.atlassian.bamboo.credentials.CredentialsDataImpl;
import com.atlassian.bamboo.credentials.CredentialsManager;
import com.atlassian.bamboo.credentials.DefaultCredentialTypeExporter;
import com.atlassian.bamboo.credentials.MutableCredentialsData;
import com.atlassian.bamboo.crypto.instance.SecretEncryptionService;
import com.atlassian.bamboo.event.analytics.GenericAnalyticsEvent;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.utils.BambooValidationUtils;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.opensymphony.xwork2.TextProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;

public class CredentialsManagerImpl
implements CredentialsManager {
    private final AuditLogService auditLogService;
    private final CredentialsDao credentialsDao;
    private final PluginAccessor pluginAccessor;
    private final TextProvider textProvider;
    private final EventPublisher eventPublisher;
    @Lazy
    @Inject
    private SecretEncryptionService secretEncryptionService;

    @Inject
    public CredentialsManagerImpl(AuditLogService auditLogService, CredentialsDao credentialsDao, EventPublisher eventPublisher, PluginAccessor pluginAccessor, TextProvider textProvider) {
        this.auditLogService = auditLogService;
        this.credentialsDao = credentialsDao;
        this.eventPublisher = eventPublisher;
        this.pluginAccessor = pluginAccessor;
        this.textProvider = textProvider;
    }

    @NotNull
    public List<CredentialTypeModuleDescriptor> getCredentialTypeDescriptors() {
        return Comparators.getModuleDescriptorNameOrdering().sortedCopy((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(CredentialTypeModuleDescriptor.class));
    }

    @Nullable
    public CredentialTypeModuleDescriptor getCredentialTypeDescriptor(@Nullable String pluginKey) {
        if (StringUtils.isNotEmpty((CharSequence)pluginKey)) {
            ModuleDescriptor descriptor = this.pluginAccessor.getEnabledPluginModule(pluginKey);
            return (CredentialTypeModuleDescriptor)Narrow.reinterpret((Object)descriptor, CredentialTypeModuleDescriptor.class);
        }
        return null;
    }

    @NotNull
    public CredentialsData updateCredentialsName(long id, @NotNull String name) throws WebValidationException {
        MutableCredentialsData encryptedCredentials = this.credentialsDao.findById(id);
        BambooValidationUtils.validate(encryptedCredentials != null, () -> "No credentials with id " + id + " could be found");
        String oldName = encryptedCredentials.getName();
        encryptedCredentials.setName(name);
        this.credentialsDao.save((BambooObject)encryptedCredentials);
        this.auditLogService.log(String.format("Shared credential [%s] has been renamed to [%s].", oldName, name));
        return this.decrypt((CredentialsData)encryptedCredentials);
    }

    @NotNull
    public CredentialsData createOrUpdateCredentials(@NotNull CredentialsData credentials) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)credentials.getPluginKey()));
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)credentials.getName()));
        MutableCredentialsData encryptedCredentials = this.credentialsDao.merge(this.encrypt(credentials));
        this.auditLogService.log(String.format("Shared credential [%s] has been created or updated.", encryptedCredentials.getName()));
        return this.decrypt((CredentialsData)encryptedCredentials);
    }

    @NotNull
    public CredentialsData createCredentials(@NotNull CredentialTypeModuleDescriptor credentialDescriptor, @NotNull String credentialsName, @NotNull Map<String, String> credentialsConfig) {
        String xml = Credentials.configToXml(credentialsConfig);
        CredentialsDataEntity credentials = new CredentialsDataEntity(credentialDescriptor.getCompleteKey(), credentialsName, xml);
        MutableCredentialsData encryptedCredentials = this.encrypt((CredentialsData)credentials);
        this.credentialsDao.save((BambooObject)encryptedCredentials);
        this.auditLogService.log(String.format("Shared credential [%s] has been created.", encryptedCredentials.getName()));
        return this.decrypt((CredentialsData)encryptedCredentials);
    }

    @NotNull
    public CredentialsData editCredentials(long credentialsId, @NotNull String credentialsName, @NotNull Map<String, String> credentialsConfig) {
        MutableCredentialsData existingCredentials = this.credentialsDao.findById(credentialsId);
        Preconditions.checkArgument((existingCredentials != null ? 1 : 0) != 0, (Object)this.textProvider.getText("sharedCredentials.edit.error.incorrectId", Collections.singletonList(credentialsId)));
        String existingCredentialsName = existingCredentials.getName();
        CredentialsDataEntity updatedCredentials = new CredentialsDataEntity((CredentialsData)existingCredentials);
        updatedCredentials.setName(credentialsName);
        updatedCredentials.setXml(Credentials.configToXml(credentialsConfig));
        MutableCredentialsData encryptedCredentials = this.credentialsDao.merge(this.encrypt((CredentialsData)updatedCredentials));
        if (existingCredentialsName.equals(credentialsName)) {
            this.auditLogService.log(String.format("Shared credential [%s] has been updated.", existingCredentialsName));
        } else {
            this.auditLogService.log(String.format("Shared credential [%s] has been renamed to [%s] and updated.", existingCredentialsName, credentialsName));
        }
        return this.decrypt((CredentialsData)encryptedCredentials);
    }

    public CredentialsData getCredentials(long id) {
        MutableCredentialsData encryptedCredentials = this.credentialsDao.findById(id);
        return encryptedCredentials != null ? this.decrypt((CredentialsData)encryptedCredentials) : null;
    }

    public CredentialsData getCredentialsByOid(BambooEntityOid oid) {
        MutableCredentialsData encryptedCredentials = this.credentialsDao.findByOid(oid);
        return encryptedCredentials != null ? this.decrypt((CredentialsData)encryptedCredentials) : null;
    }

    public CredentialsData getCredentialsByName(String name) {
        MutableCredentialsData encryptedCredentials = this.credentialsDao.findByName(name);
        return encryptedCredentials != null ? this.decrypt((CredentialsData)encryptedCredentials) : null;
    }

    @NotNull
    public Iterable<CredentialsData> getAllCredentials() {
        return this.credentialsDao.findAll().stream().map(this::decrypt).collect(Collectors.toList());
    }

    @NotNull
    public Iterable<CredentialsData> getAllCredentials(@NotNull String pluginKey) {
        return this.credentialsDao.findByPluginKey(pluginKey).stream().map(this::decrypt).collect(Collectors.toList());
    }

    public boolean hasAnyCredentials(@NotNull String pluginKey) {
        return this.credentialsDao.hasAnyCredentials(pluginKey);
    }

    public void deleteCredentials(long id) {
        MutableCredentialsData mutableCredentials = this.credentialsDao.findById(id);
        if (mutableCredentials != null) {
            this.credentialsDao.delete((BambooObject)mutableCredentials);
            this.auditLogService.log(String.format("Shared credential [%s] has been deleted.", mutableCredentials.getName()));
        }
    }

    public void validate(@NotNull CredentialsData importedEntity) throws PropertiesValidationException {
        MutableCredentialsData oldEntity;
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        if (importedEntity.getOid() != null) {
            MutableCredentialsData entityWithSameName;
            oldEntity = this.credentialsDao.findByOid(importedEntity.getOid());
            if (!(oldEntity != null && StringUtils.equals((CharSequence)importedEntity.getName(), (CharSequence)oldEntity.getName()) || (entityWithSameName = this.credentialsDao.findByName(importedEntity.getName())) == null || entityWithSameName.getOid().equals((Object)importedEntity.getOid()))) {
                errors.add(new ValidationProblem(this.textProvider.getText("sharedCredentials.validate.name.not.unique", Collections.singletonList(importedEntity.getName()))));
            }
        } else {
            oldEntity = this.credentialsDao.findByName(importedEntity.getName());
        }
        if (oldEntity != null && !StringUtils.equals((CharSequence)importedEntity.getPluginKey(), (CharSequence)oldEntity.getPluginKey())) {
            errors.add(new ValidationProblem(this.textProvider.getText("sharedCredentials.validate.type.can.not.be.changed", (List)ImmutableList.of((Object)oldEntity.getPluginKey(), (Object)importedEntity.getPluginKey()))));
        }
        if (!errors.isEmpty()) {
            throw new PropertiesValidationException(errors);
        }
    }

    @NotNull
    public CredentialTypeExporter retrieveCredentialTypeExporter(@Nullable String pluginKey) {
        return Optional.ofNullable(pluginKey).map(this::getCredentialTypeDescriptor).map(CredentialTypeModuleDescriptor::getExporter).orElseGet(DefaultCredentialTypeExporter::new);
    }

    @NotNull
    public CredentialsData mergeImportedEntity(@NotNull CredentialsData importedEntity) {
        MutableCredentialsData existingEntity = importedEntity.getOid() != null ? this.credentialsDao.findByOid(importedEntity.getOid()) : this.credentialsDao.findByName(importedEntity.getName());
        MutableCredentialsData entityToPersist = this.encrypt(importedEntity);
        if (existingEntity != null) {
            entityToPersist.setId(existingEntity.getId());
            entityToPersist.setOid(existingEntity.getOid());
        }
        MutableCredentialsData encryptedCredentials = this.credentialsDao.merge(entityToPersist);
        if (existingEntity != null) {
            this.eventPublisher.publish((Object)new GenericAnalyticsEvent("bamboo.import.credential.update"));
            this.auditLogService.log(String.format("Shared credential [%s] has been updated.", encryptedCredentials.getName()));
        } else {
            this.eventPublisher.publish((Object)new GenericAnalyticsEvent("bamboo.import.credential.create"));
            this.auditLogService.log(String.format("Shared credential [%s] has been created.", encryptedCredentials.getName()));
        }
        return this.decrypt((CredentialsData)encryptedCredentials);
    }

    @Contract(value="null -> null")
    @VisibleForTesting
    MutableCredentialsData encrypt(@Nullable CredentialsData credentialsData) {
        if (credentialsData == null) {
            return null;
        }
        Map configuration = credentialsData.getConfiguration();
        Map encryptedConfiguration = Maps.transformEntries((Map)configuration, (configKey, configValue) -> configValue != null && PasswordMaskingUtils.shouldBeMasked((String)configKey) && !this.secretEncryptionService.isEncrypted(configValue) ? this.secretEncryptionService.encrypt(configValue) : configValue);
        CredentialsDataEntity decryptedCredentials = new CredentialsDataEntity(credentialsData);
        decryptedCredentials.setXml(Credentials.configToXml(encryptedConfiguration));
        return decryptedCredentials;
    }

    @Contract(value="null -> null")
    @VisibleForTesting
    CredentialsData decrypt(@Nullable CredentialsData credentialsData) {
        if (credentialsData == null) {
            return null;
        }
        Map configuration = credentialsData.getConfiguration();
        Map decryptedConfiguration = Maps.transformEntries((Map)configuration, (configKey, configValue) -> configValue != null && PasswordMaskingUtils.shouldBeMasked((String)configKey) && this.secretEncryptionService.isEncrypted(configValue) ? this.secretEncryptionService.decrypt(configValue) : configValue);
        CredentialsDataEntity decryptedCredentials = new CredentialsDataEntity(credentialsData);
        decryptedCredentials.setXml(Credentials.configToXml(decryptedConfiguration));
        return new CredentialsDataImpl((CredentialsData)decryptedCredentials);
    }
}

