/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.credentials;

import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.credentials.CredentialsDao;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.credentials.CredentialsDataImpl;
import com.atlassian.bamboo.credentials.EncryptedCredentialsAccessor;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class EncryptedCredentialsAccessorImpl
implements EncryptedCredentialsAccessor {
    private final CredentialsDao credentialsDao;

    @Inject
    public EncryptedCredentialsAccessorImpl(CredentialsDao credentialsDao) {
        this.credentialsDao = credentialsDao;
    }

    @NotNull
    public List<CredentialsData> getAllCredentials() {
        return this.credentialsDao.findAll().stream().map(CredentialsDataImpl::new).collect(Collectors.toList());
    }

    @NotNull
    public Optional<CredentialsData> getCredentialsById(long id) {
        return Optional.ofNullable(this.credentialsDao.findById(id)).map(CredentialsDataImpl::new);
    }

    @NotNull
    public Optional<CredentialsData> getCredentialsByOid(@NotNull BambooEntityOid oid) {
        return Optional.ofNullable(this.credentialsDao.findByOid(oid)).map(CredentialsDataImpl::new);
    }

    @NotNull
    public Optional<CredentialsData> getCredentialsByName(@NotNull String name) {
        return Optional.ofNullable(this.credentialsDao.findByName(name)).map(CredentialsDataImpl::new);
    }
}

