/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.credentials;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.credentials.AbstractCredentialType;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.credentials.SshCredentialsImpl;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.utils.BambooValidationUtils;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.security.password.DefaultPasswordEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshCredentialType
extends AbstractCredentialType {
    public static final String SSH_CREDENTIALS_PLUGIN_KEY = "com.atlassian.bamboo.plugin.sharedCredentials:sshCredentials";
    private static final String CFG_UPDATE_SSH_KEY = "updateSshKey";
    public static final String CFG_SSH_KEY = "sshKey";
    public static final String CFG_SSH_PASSPHRASE = "sshPassphrase";

    @Override
    public void validate(@NotNull ActionParametersMap params, @Nullable CredentialsData previousCredentialsData, @NotNull ErrorCollection errorCollection) {
        super.validate(params, previousCredentialsData, errorCollection);
        if (params.getBoolean(CFG_UPDATE_SSH_KEY) && StringUtils.isBlank((CharSequence)params.getString(CFG_SSH_KEY))) {
            errorCollection.addError(CFG_SSH_KEY, this.textProvider.getText("credentials.ssh.key.empty"));
        }
    }

    @NotNull
    public Map<String, String> generateCredentialsConfigMap(@NotNull ActionParametersMap params, @Nullable CredentialsData previousCredentialsData) {
        String sshPassphrase;
        String sshKey;
        HashMap<String, String> configMap = new HashMap<String, String>();
        if (params.getBoolean(CFG_UPDATE_SSH_KEY)) {
            sshKey = params.getString(CFG_SSH_KEY);
            sshPassphrase = params.getString(CFG_SSH_PASSPHRASE);
        } else {
            SshCredentialsImpl sshCredentials = new SshCredentialsImpl(previousCredentialsData);
            sshKey = sshCredentials.getKey();
            sshPassphrase = sshCredentials.getPassphrase();
        }
        configMap.put(CFG_SSH_KEY, sshKey);
        configMap.put(CFG_SSH_PASSPHRASE, sshPassphrase);
        return configMap;
    }

    @Override
    @NotNull
    public Map<String, String> getCredentialsConfigurationMap(@NotNull CredentialsData credentialsData) {
        HashMap<String, String> configuration = new HashMap<String, String>();
        SshCredentialsImpl sshCredentials = new SshCredentialsImpl(credentialsData);
        configuration.put(CFG_SSH_KEY, DefaultPasswordEncoder.getDefaultInstance().encodePassword(sshCredentials.getKey()));
        if (!StringUtils.isEmpty((CharSequence)sshCredentials.getPassphrase())) {
            configuration.put(CFG_SSH_PASSPHRASE, DefaultPasswordEncoder.getDefaultInstance().encodePassword(sshCredentials.getPassphrase()));
        }
        return configuration;
    }

    @Override
    @NotNull
    public Map<String, String> generateCredentialsConfigMap(@NotNull Map<String, String> params) throws WebValidationException {
        boolean hasInvalidConfiguration;
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (StringUtils.isEmpty((CharSequence)params.get(CFG_SSH_KEY))) {
            errorCollection.addError(CFG_SSH_KEY, this.textProvider.getText("credentials.ssh.key.empty"));
        }
        if (hasInvalidConfiguration = params.keySet().stream().anyMatch(input -> !CFG_SSH_KEY.equals(input) && !CFG_SSH_PASSPHRASE.equals(input))) {
            errorCollection.addErrorMessage(this.textProvider.getText("credentials.ssh.configuration.invalid"));
        }
        BambooValidationUtils.checkErrors((ErrorCollection)errorCollection);
        HashMap<String, String> configMap = new HashMap<String, String>();
        String sshKey = params.get(CFG_SSH_KEY);
        String sshPassphrase = params.getOrDefault(CFG_SSH_PASSPHRASE, "");
        configMap.put(CFG_SSH_KEY, sshKey);
        configMap.put(CFG_SSH_PASSPHRASE, sshPassphrase);
        return configMap;
    }
}

