/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.credentials;

import com.atlassian.bamboo.credentials.CredentialTypeExporter;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.exception.YamlValidationException;
import com.atlassian.bamboo.specs.api.builders.credentials.SharedCredentials;
import com.atlassian.bamboo.specs.api.model.credentials.SharedCredentialsProperties;
import com.atlassian.bamboo.specs.builders.credentials.SshCredentials;
import com.atlassian.bamboo.specs.model.credentials.SshCredentialsProperties;
import com.atlassian.struts.TextProvider;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;

public class SshCredentialTypeExporter
implements CredentialTypeExporter {
    private final TextProvider textProvider;

    @Inject
    public SshCredentialTypeExporter(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    public Map<String, String> toCredentialsConfiguration(SharedCredentialsProperties entityProperties) throws YamlValidationException {
        SshCredentialsProperties props = (SshCredentialsProperties)entityProperties;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("sshKey", props.getKey());
        result.put("sshPassphrase", props.getPassphrase());
        return result;
    }

    public SharedCredentials toSpecsEntity(CredentialsData credentialsData) {
        Map configuration = credentialsData.getConfiguration();
        String key = (String)configuration.get("sshKey");
        String passphrase = (String)configuration.get("sshPassphrase");
        return new SshCredentials().privateKey(key).passphrase(passphrase);
    }
}

