/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.credentials;

import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.credentials.PrivateKeyCredentials;
import com.atlassian.bamboo.utils.BambooInterners;
import com.google.common.base.Strings;
import java.util.Map;

public class SshCredentialsImpl
implements PrivateKeyCredentials {
    private final String sshKey;
    private final String sshPassphrase;

    public SshCredentialsImpl(String sshKey, String sshPassphrase) {
        this.sshKey = sshKey;
        this.sshPassphrase = sshPassphrase;
    }

    public SshCredentialsImpl(CredentialsData credentials) {
        Map configuration = credentials.getConfiguration();
        this.sshKey = BambooInterners.intern((String)((String)configuration.get("sshKey")));
        this.sshPassphrase = BambooInterners.intern((String)((String)configuration.get("sshPassphrase")));
        if (Strings.isNullOrEmpty((String)this.sshKey)) {
            throw new IllegalArgumentException("The xml provided for credentials have an empty or null sshKey");
        }
    }

    public String getKey() {
        return this.sshKey;
    }

    public String getPassphrase() {
        return this.sshPassphrase;
    }
}

