/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.credentials;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.credentials.AbstractCredentialType;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.credentials.UsernamePasswordCredentials;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.utils.BambooValidationUtils;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.security.password.DefaultPasswordEncoder;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsernamePasswordCredentialType
extends AbstractCredentialType {
    public static final String PLUGIN_KEY = "com.atlassian.bamboo.plugin.sharedCredentials:usernamePasswordCredentials";
    static final String CFG_UPDATE_PASSWORD = "updatePassword";
    public static final String CFG_USERNAME = "username";
    public static final String CFG_PASSWORD = "password";

    @Override
    public void validate(@NotNull ActionParametersMap params, @Nullable CredentialsData previousCredentialsData, @NotNull ErrorCollection errorCollection) {
        super.validate(params, previousCredentialsData, errorCollection);
        if (StringUtils.isEmpty((CharSequence)params.getString(CFG_USERNAME))) {
            errorCollection.addError(CFG_USERNAME, this.textProvider.getText("credentials.usernamePassword.username.error.empty"));
        }
    }

    @NotNull
    public Map<String, String> generateCredentialsConfigMap(@NotNull ActionParametersMap params, @Nullable CredentialsData previousCredentialsData) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        String username = params.getString(CFG_USERNAME);
        String password = params.getBoolean(CFG_UPDATE_PASSWORD) || previousCredentialsData == null ? params.getString(CFG_PASSWORD, "") : new UsernamePasswordCredentials(previousCredentialsData).getPassword();
        configMap.put(CFG_USERNAME, username);
        configMap.put(CFG_PASSWORD, password);
        return configMap;
    }

    @Override
    @NotNull
    public Map<String, String> getCredentialsConfigurationMap(@NotNull CredentialsData credentialsData) {
        HashMap<String, String> configuration = new HashMap<String, String>();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(credentialsData);
        configuration.put(CFG_USERNAME, credentials.getUsername());
        configuration.put(CFG_PASSWORD, DefaultPasswordEncoder.getDefaultInstance().encodePassword(credentials.getPassword()));
        return configuration;
    }

    @Override
    @NotNull
    public Map<String, String> generateCredentialsConfigMap(@NotNull Map<String, String> params) throws WebValidationException {
        BambooValidationUtils.validateField(CFG_USERNAME, StringUtils.isNotEmpty((CharSequence)params.get(CFG_USERNAME)), () -> this.textProvider.getText("credentials.usernamePassword.username.error.empty"));
        return ImmutableMap.of((Object)CFG_USERNAME, (Object)params.get(CFG_USERNAME), (Object)CFG_PASSWORD, (Object)params.getOrDefault(CFG_PASSWORD, ""));
    }

    @Override
    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull CredentialsData previousCredentialsData) {
        super.populateContextForEdit(context, previousCredentialsData);
        context.put(CFG_USERNAME, previousCredentialsData.getConfiguration().get(CFG_USERNAME));
    }
}

