/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.credentials;

import com.atlassian.bamboo.credentials.CredentialTypeExporter;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.exception.YamlValidationException;
import com.atlassian.bamboo.specs.api.builders.credentials.SharedCredentials;
import com.atlassian.bamboo.specs.api.model.credentials.SharedCredentialsProperties;
import com.atlassian.bamboo.specs.builders.credentials.UsernamePasswordCredentials;
import com.atlassian.bamboo.specs.model.credentials.UsernamePasswordCredentialsProperties;
import com.atlassian.struts.TextProvider;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;

public class UsernamePasswordCredentialTypeExporter
implements CredentialTypeExporter {
    private final TextProvider textProvider;

    @Inject
    public UsernamePasswordCredentialTypeExporter(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    public Map<String, String> toCredentialsConfiguration(SharedCredentialsProperties entityProperties) throws YamlValidationException {
        UsernamePasswordCredentialsProperties props = (UsernamePasswordCredentialsProperties)entityProperties;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("username", props.getUsername());
        result.put("password", props.getPassword());
        return result;
    }

    public SharedCredentials toSpecsEntity(CredentialsData credentialsData) {
        Map configuration = credentialsData.getConfiguration();
        String username = (String)configuration.get("username");
        String password = (String)configuration.get("password");
        return new UsernamePasswordCredentials().username(username).password(password);
    }
}

