/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.credentials;

import com.atlassian.bamboo.credentials.CredentialsData;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class UsernamePasswordCredentials {
    private final String username;
    private final String password;

    public UsernamePasswordCredentials(@NotNull String username, @NotNull String password) {
        this.username = username;
        this.password = password;
    }

    public UsernamePasswordCredentials(@NotNull CredentialsData credentials) {
        Map configuration = credentials.getConfiguration();
        Preconditions.checkArgument((boolean)configuration.containsKey("username"), (Object)"Configuration doesn't contain username - value is required");
        this.username = (String)configuration.get("username");
        this.password = configuration.getOrDefault("password", "");
    }

    @NotNull
    public String getUsername() {
        return this.username;
    }

    @NotNull
    public String getPassword() {
        return this.password;
    }
}

