/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.crowd;

import com.atlassian.bamboo.crowd.DelegatingCrowdDirectoryService;
import com.atlassian.crowd.embedded.api.ApplicationFactory;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryCurrentlySynchronisingException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationManagerException;

public class BambooCrowdDirectoryService
extends DelegatingCrowdDirectoryService {
    private final ApplicationManager applicationManager;
    private final ApplicationFactory applicationFactory;

    public BambooCrowdDirectoryService(CrowdDirectoryService delegate, ApplicationManager applicationManager, ApplicationFactory applicationFactory) {
        super(delegate);
        this.applicationManager = applicationManager;
        this.applicationFactory = applicationFactory;
    }

    @Override
    public Directory addDirectory(Directory directory) throws OperationFailedException {
        Directory newDirectory = this.delegate.addDirectory(directory);
        try {
            this.applicationManager.addDirectoryMapping(this.applicationFactory.getApplication(), newDirectory, true, OperationType.values());
        }
        catch (ApplicationNotFoundException | DirectoryNotFoundException e) {
            throw new OperationFailedException("Could not add Directory to Embedded Crowd application mapping", e);
        }
        return newDirectory;
    }

    @Override
    public boolean removeDirectory(long directoryId) throws DirectoryCurrentlySynchronisingException, OperationFailedException {
        Directory directoryToRemove = this.delegate.findDirectoryById(directoryId);
        if (directoryToRemove != null) {
            try {
                this.applicationManager.removeDirectoryFromApplication(directoryToRemove, this.applicationFactory.getApplication());
            }
            catch (ApplicationManagerException e) {
                throw new OperationFailedException("Could not remove Directory to Embedded Crowd application mapping", (Throwable)e);
            }
            return this.delegate.removeDirectory(directoryId);
        }
        return false;
    }
}

