/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.crowd;

import com.atlassian.bamboo.event.ServerStartedEvent;
import com.atlassian.bamboo.util.BambooSpringUtils;
import com.atlassian.crowd.event.directory.DirectoryCreatedEvent;
import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorRefresherJob;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.google.common.base.Preconditions;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

public final class BambooDirectoryMonitorRefresherStarter {
    private static final Logger log = LoggerFactory.getLogger(BambooDirectoryMonitorRefresherStarter.class);
    private static final JobId JOB_ID = JobId.of((String)(BambooDirectoryMonitorRefresherStarter.class.getName() + "-job"));
    @Inject
    private AutowireCapableBeanFactory autowireCapableBeanFactory;
    private final EventPublisher eventPublisher;
    private final SchedulerService schedulerService;
    private final long refresherJobIntervalMillis;

    public BambooDirectoryMonitorRefresherStarter(EventPublisher eventPublisher, SchedulerService schedulerService, long refresherJobIntervalMillis) {
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
        this.schedulerService = schedulerService;
        this.refresherJobIntervalMillis = refresherJobIntervalMillis;
    }

    @PostConstruct
    public void registerListener() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void unregisterListener() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onServerStartedEvent(ServerStartedEvent event) {
        BambooSpringUtils.createCompleteComponent(DirectoryMonitorRefresherJob.class);
        this.triggerDirectoryMonitoringJob((Object)event);
    }

    @EventListener
    public void handleEvent(DirectoryUpdatedEvent event) {
        this.triggerDirectoryMonitoringJob(event);
    }

    @EventListener
    public void handleEvent(DirectoryDeletedEvent event) {
        this.triggerDirectoryMonitoringJob(event);
    }

    @EventListener
    public void handleEvent(DirectoryCreatedEvent event) {
        this.triggerDirectoryMonitoringJob(event);
    }

    private void triggerDirectoryMonitoringJob(Object cause) {
        try {
            log.debug("Rescheduling directory monitoring job due to {}", cause);
            this.schedulerService.scheduleJob(JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)DirectoryMonitorRefresherJob.JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)this.refresherJobIntervalMillis, null)));
        }
        catch (SchedulerServiceException e) {
            log.warn("Failed to reschedule directory monitoring job", (Throwable)e);
        }
    }
}

