/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.crypto;

import com.atlassian.security.random.DefaultSecureRandomService;
import com.atlassian.security.random.SecureRandomService;
import org.apache.sshd.common.random.AbstractRandom;
import org.apache.sshd.common.random.AbstractRandomFactory;
import org.apache.sshd.common.random.Random;

public class AtlassianRandom
extends AbstractRandom {
    private final SecureRandomService secureRandomService = DefaultSecureRandomService.getInstance();

    public void fill(byte[] output, int start, int len) {
        byte[] randomBytes = new byte[len];
        this.secureRandomService.nextBytes(randomBytes);
        System.arraycopy(randomBytes, 0, output, start, len);
    }

    public int random(int i) {
        return this.secureRandomService.nextInt(i);
    }

    public String getName() {
        return "atlassian-random";
    }

    public static class Factory
    extends AbstractRandomFactory {
        public Factory() {
            super("atlassian-random-factory");
        }

        public Random create() {
            return new AtlassianRandom();
        }

        public boolean isSupported() {
            return true;
        }
    }
}

