/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.crypto;

import com.atlassian.bamboo.util.Narrow;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import org.apache.log4j.Logger;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.dsa.DSAUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BouncyCastleProviderUtils {
    private static final Logger log = Logger.getLogger(BouncyCastleProviderUtils.class);
    public static final JcaPEMKeyConverter JCA_PEM_KEY_CONVERTER = new JcaPEMKeyConverter().setProvider(BouncyCastleProviderUtils.getProviderName());

    private BouncyCastleProviderUtils() {
    }

    public static String getProviderName() {
        return "BC";
    }

    @NotNull
    public static Provider getProvider() {
        Provider provider = Security.getProvider("BC");
        Preconditions.checkState((provider != null ? 1 : 0) != 0, (Object)"Bouncy Castle provider not available");
        return provider;
    }

    public static KeyPair toJavaKeyPair(PEMKeyPair keyPair) throws PEMException {
        return JCA_PEM_KEY_CONVERTER.getKeyPair(keyPair);
    }

    public static KeyPair toJavaKeyPair(@NotNull Object keyPair, @Nullable String passPhrase) throws IOException {
        PEMKeyPair pemKeyPair;
        Preconditions.checkArgument((keyPair != null ? 1 : 0) != 0, (Object)"Key pair is null");
        PEMEncryptedKeyPair pemEncryptedKeyPair = (PEMEncryptedKeyPair)Narrow.downTo((Object)keyPair, PEMEncryptedKeyPair.class);
        if (pemEncryptedKeyPair != null) {
            pemKeyPair = BouncyCastleProviderUtils.decrypt(pemEncryptedKeyPair, passPhrase);
        } else {
            pemKeyPair = (PEMKeyPair)Narrow.downTo((Object)keyPair, PEMKeyPair.class);
            Preconditions.checkArgument((pemKeyPair != null ? 1 : 0) != 0, (Object)("Unknown key pair class: " + keyPair.getClass()));
        }
        return BouncyCastleProviderUtils.toJavaKeyPair(pemKeyPair);
    }

    private static PEMKeyPair decrypt(@NotNull PEMEncryptedKeyPair keyPair, @Nullable String passPhrase) throws IOException {
        Preconditions.checkArgument((passPhrase != null ? 1 : 0) != 0, (Object)"Unable to decrypt an encrypted key, passphrase was not provided");
        PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build(passPhrase.toCharArray());
        return keyPair.decryptKeyPair(decProv);
    }

    @NotNull
    public static AsymmetricKeyParameter getKeyParameters(PrivateKey privateKey) {
        Object privateKeyParamaters;
        try {
            privateKeyParamaters = privateKey instanceof RSAPrivateKey ? BouncyCastleProviderUtils.generatePrivateKeyParameter((RSAPrivateKey)privateKey) : DSAUtil.generatePrivateKeyParameter((PrivateKey)privateKey);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Unable to generate key parameters for key", e);
        }
        return privateKeyParamaters;
    }

    private static RSAKeyParameters generatePrivateKeyParameter(RSAPrivateKey rsaPrivateKey) {
        RSAPrivateCrtKey k = (RSAPrivateCrtKey)Narrow.downTo((Object)rsaPrivateKey, RSAPrivateCrtKey.class);
        if (k == null) {
            return new RSAKeyParameters(true, rsaPrivateKey.getModulus(), rsaPrivateKey.getPrivateExponent());
        }
        return new RSAPrivateCrtKeyParameters(k.getModulus(), k.getPublicExponent(), k.getPrivateExponent(), k.getPrimeP(), k.getPrimeQ(), k.getPrimeExponentP(), k.getPrimeExponentQ(), k.getCrtCoefficient());
    }

    static {
        if (Security.getProvider(BouncyCastleProviderUtils.getProviderName()) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        } else {
            log.info((Object)"Bouncy Castle provider already present");
        }
    }
}

