/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.crypto.instance;

import com.atlassian.bamboo.crypto.instance.CipherSpec;
import com.atlassian.bamboo.crypto.instance.EncryptorWithSpec;
import com.atlassian.bamboo.crypto.instance.InstanceSecretStorage;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.jetbrains.annotations.NotNull;

class InstanceCipherProvider {
    private static final CipherSpec CURRENT_CIPHER_SPEC = new CipherSpec(0, 0);
    private static final boolean FOR_ENCRYPTION = true;
    private static final boolean FOR_DECRYPTION = false;
    private final InstanceSecretStorage instanceSecretStorage;

    InstanceCipherProvider(InstanceSecretStorage instanceSecretStorage) {
        this.instanceSecretStorage = instanceSecretStorage;
    }

    void initialiseCurrentCipher() {
        this.instanceSecretStorage.getKeyAndIv(InstanceCipherProvider.newCipher(), CURRENT_CIPHER_SPEC.getCipherDataId(), false);
    }

    void reloadCurrentCipher() {
        this.instanceSecretStorage.getKeyAndIvForceReload(InstanceCipherProvider.newCipher(), CURRENT_CIPHER_SPEC.getCipherDataId(), false);
    }

    @NotNull
    EncryptorWithSpec getEncryptor() {
        return new EncryptorWithSpec(this.getCipher(true, CURRENT_CIPHER_SPEC), CURRENT_CIPHER_SPEC);
    }

    @NotNull
    PaddedBufferedBlockCipher getDecryptor(CipherSpec cipherSpec) {
        return this.getCipher(false, cipherSpec);
    }

    @NotNull
    private PaddedBufferedBlockCipher getCipher(boolean forEncryption, CipherSpec cipherSpec) {
        BlockCipher cipher = InstanceCipherProvider.newCipher();
        boolean onlyIfPresent = !forEncryption;
        Pair<byte[], byte[]> keyAndIv = this.getKeyAndIv(cipherSpec, cipher, onlyIfPresent);
        KeyParameter keyParameter = new KeyParameter((byte[])keyAndIv.getKey());
        PaddedBufferedBlockCipher encryptCipher = InstanceCipherProvider.makePaddedCbcCipher(cipher);
        ParametersWithIV paramsWithIv = new ParametersWithIV((CipherParameters)keyParameter, (byte[])keyAndIv.getValue());
        encryptCipher.init(forEncryption, (CipherParameters)paramsWithIv);
        return encryptCipher;
    }

    @NotNull
    protected Pair<byte[], byte[]> getKeyAndIv(CipherSpec cipherSpec, BlockCipher cipher, boolean onlyIfPresent) {
        return this.instanceSecretStorage.getKeyAndIv(cipher, cipherSpec.getCipherDataId(), onlyIfPresent);
    }

    @NotNull
    private static PaddedBufferedBlockCipher makePaddedCbcCipher(BlockCipher cipher) {
        return new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher(cipher));
    }

    private static BlockCipher newCipher() {
        return new AESEngine();
    }
}

