/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.crypto.instance;

import com.atlassian.bamboo.crypto.instance.SecretEncryptionService;
import com.atlassian.bamboo.crypto.instance.SecretEncryptionServiceInternal;
import com.atlassian.bamboo.utils.SystemProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Lazy;

public class SecretEncryptionServiceImpl
implements SecretEncryptionService {
    private static final Logger log = Logger.getLogger(SecretEncryptionServiceImpl.class);
    @Inject
    @Lazy
    private SecretEncryptionServiceInternal secretEncryptionService;

    public boolean isEncrypted(@NotNull String string) {
        return this.secretEncryptionService.isEncrypted(string);
    }

    @NotNull
    public String decrypt(@NotNull String encryptedSecret) {
        if (SystemProperty.DISABLE_ENCRYPTION.getTypedValue()) {
            return encryptedSecret;
        }
        try {
            return this.secretEncryptionService.decrypt(encryptedSecret);
        }
        catch (RuntimeException e) {
            if (SystemProperty.IGNORE_DECRYPTION_ERRORS.getTypedValue()) {
                log.debug((Object)"Ignore decryption error. Return undecoded value.");
                return encryptedSecret;
            }
            log.info((Object)("Can't decrypt data. It's possible data was encrypted by different cipher. Run Bamboo with system property -D" + SystemProperty.IGNORE_DECRYPTION_ERRORS.getKey() + "=true to ignore this error"));
            throw Throwables.propagate((Throwable)e);
        }
    }

    @NotNull
    public String encrypt(@NotNull String secretToEncrypt) {
        if (SystemProperty.DISABLE_ENCRYPTION.getTypedValue()) {
            return secretToEncrypt;
        }
        return this.secretEncryptionService.encrypt(secretToEncrypt);
    }

    @VisibleForTesting
    protected void setSecretEncryptionService(SecretEncryptionServiceInternal secretEncryptionService) {
        this.secretEncryptionService = secretEncryptionService;
    }
}

