/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.crypto.instance;

import com.atlassian.bamboo.crypto.instance.CipherSpec;
import com.atlassian.bamboo.crypto.instance.EncryptorWithSpec;
import com.atlassian.bamboo.crypto.instance.InstanceCipherProvider;
import com.atlassian.bamboo.crypto.instance.InstanceSecretStorage;
import com.atlassian.bamboo.crypto.instance.SecretEncryptionService;
import com.atlassian.bamboo.crypto.instance.SecretEncryptionServiceImpl;
import com.atlassian.bamboo.crypto.instance.SecretEncryptionServiceInternal;
import com.atlassian.bandana.BandanaManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import io.atlassian.util.concurrent.Lazy;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SecretEncryptionServiceInternalImpl
implements SecretEncryptionServiceInternal {
    private static final Logger log = Logger.getLogger(SecretEncryptionServiceInternalImpl.class);
    @Inject
    private BandanaManager bandanaManager;
    InstanceCipherProvider instanceCipherProvider;

    @PostConstruct
    private void postConstruct() {
        try {
            this.instanceCipherProvider = new InstanceCipherProvider(new InstanceSecretStorage(this.bandanaManager));
            this.instanceCipherProvider.initialiseCurrentCipher();
        }
        catch (Error | RuntimeException e) {
            log.fatal((Object)"", e);
        }
    }

    @Override
    public boolean isEncrypted(@NotNull String string) {
        return ArmoredString.is(string);
    }

    @Override
    @NotNull
    public String decrypt(@NotNull String encryptedSecret) {
        ArmoredString ciphertext = ArmoredString.from(encryptedSecret);
        byte[] decrypt = SecretEncryptionServiceInternalImpl.decrypt(this.instanceCipherProvider.getDecryptor(ciphertext.getCipherSpec()), ciphertext.getCiphertext());
        return new String(decrypt, StandardCharsets.UTF_8);
    }

    @Override
    @NotNull
    public String encrypt(@NotNull String secretToEncrypt) {
        ArmoredString armoredString = this.encrypt(secretToEncrypt.getBytes(StandardCharsets.UTF_8));
        return armoredString.toString();
    }

    @Override
    public void reloadCipher() {
        this.instanceCipherProvider.reloadCurrentCipher();
    }

    private ArmoredString encrypt(byte[] bytes) {
        EncryptorWithSpec encryptorWithSpec = this.instanceCipherProvider.getEncryptor();
        byte[] ciphertext = this.encrypt(encryptorWithSpec.getEncryptor(), bytes);
        return ArmoredString.from(encryptorWithSpec.getCipherSpec(), ciphertext);
    }

    private static byte[] decrypt(PaddedBufferedBlockCipher decryptor, byte[] ciphertext) {
        int finalBlockLen;
        byte[] decrypted = new byte[ciphertext.length];
        int initialBlockLen = decryptor.processBytes(ciphertext, 0, ciphertext.length, decrypted, 0);
        try {
            finalBlockLen = decryptor.doFinal(decrypted, initialBlockLen);
        }
        catch (InvalidCipherTextException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return Arrays.copyOfRange(decrypted, 0, initialBlockLen + finalBlockLen);
    }

    protected byte[] encrypt(PaddedBufferedBlockCipher encryptCipher, byte[] toEncrypt) {
        int finalChunkLen;
        byte[] ciphertext = new byte[toEncrypt.length + 2 * encryptCipher.getBlockSize()];
        int initialLen = encryptCipher.processBytes(toEncrypt, 0, toEncrypt.length, ciphertext, 0);
        try {
            finalChunkLen = encryptCipher.doFinal(ciphertext, initialLen);
        }
        catch (InvalidCipherTextException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return Arrays.copyOfRange(ciphertext, 0, initialLen + finalChunkLen);
    }

    @VisibleForTesting
    public static SecretEncryptionService forTesting() {
        SecretEncryptionServiceInternalImpl secretEncryptionServiceInternal = new SecretEncryptionServiceInternalImpl();
        secretEncryptionServiceInternal.instanceCipherProvider = new InstanceCipherProvider(new InstanceSecretStorage(null)){
            private final Supplier<Pair<byte[], byte[]>> keyAndIv = Lazy.supplier(() -> {
                Random random = new Random();
                byte[] key = new byte[32];
                random.nextBytes(key);
                byte[] iv = new byte[16];
                random.nextBytes(iv);
                return Pair.of((Object)key, (Object)iv);
            });

            @Override
            @NotNull
            protected Pair<byte[], byte[]> getKeyAndIv(CipherSpec cipherSpec, BlockCipher cipher, boolean onlyIfPresent) {
                return this.keyAndIv.get();
            }
        };
        SecretEncryptionServiceImpl secretEncryptionService = new SecretEncryptionServiceImpl();
        secretEncryptionService.setSecretEncryptionService(secretEncryptionServiceInternal);
        return secretEncryptionService;
    }

    private static final class ArmoredString {
        private static final char SEPARATOR_CHAR = '@';
        private static final String BAMSCRT = "BAMSCRT";
        private final CipherSpec cipherSpec;
        private final byte[] ciphertext;

        public ArmoredString(CipherSpec cipherSpec, byte[] ciphertext) {
            this.cipherSpec = cipherSpec;
            this.ciphertext = ciphertext;
        }

        public byte[] getCiphertext() {
            return this.ciphertext;
        }

        public CipherSpec getCipherSpec() {
            return this.cipherSpec;
        }

        public static ArmoredString from(@NotNull String armoredString) {
            Objects.requireNonNull(armoredString, "Ciphertext must not be null");
            String[] split = StringUtils.split((String)armoredString, (char)'@');
            if (split.length != 4) {
                throw new IllegalArgumentException("Unknown encrypted data format: [" + armoredString + ']');
            }
            CipherSpec cipherSpec = new CipherSpec(Integer.valueOf(split[1]), Integer.valueOf(split[2]));
            return new ArmoredString(cipherSpec, Base64.getDecoder().decode(split[3]));
        }

        public static ArmoredString from(CipherSpec cipherSpec, byte[] ciphertext) {
            return new ArmoredString(cipherSpec, ciphertext);
        }

        public String toString() {
            return "BAMSCRT@" + this.cipherSpec.getAlgorithmId() + '@' + this.cipherSpec.getCipherDataId() + '@' + Base64.getEncoder().encodeToString(this.ciphertext);
        }

        public static boolean is(@Nullable String string) {
            return StringUtils.startsWith((CharSequence)string, (CharSequence)BAMSCRT);
        }
    }
}

