/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.deletion;

import com.atlassian.bamboo.deletion.DeletionServiceJob;
import com.atlassian.bamboo.deletion.OrphanedBuildResultRemovalJob;
import com.atlassian.bamboo.schedule.BambooScheduler;
import org.apache.log4j.Logger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class DeletionScheduler
implements BambooScheduler {
    private static final Logger log = Logger.getLogger(DeletionScheduler.class);
    private static final String JOB_NAME = "Plan Deletion Job";
    private static final String JOB_GROUP = "Plan Deletion Service Group";
    private static final int INTERVAL_SECONDS = 120;
    private static final String ORPHANED_RESULT_JOB_NAME = "Orphaned Result Deletion Job";
    private static final String ORPHANED_RESULT_JOB_GROUP = "Orphaned Result Service Group";
    private static final TriggerKey ORPHANED_TRIGGER_KEY = new TriggerKey("Orphaned Result Deletion Job", "Orphaned Result Service Group");
    private static final JobKey ORPHANED_JOB_KEY = new JobKey("Orphaned Result Deletion Job", "Orphaned Result Service Group");
    private static final int ORPHANED_RESULT_INTERVAL_SECONDS = 86400;
    private final Scheduler quartzScheduler;
    private static final TriggerKey TRIGGER_KEY = new TriggerKey("Plan Deletion Job", "Plan Deletion Service Group");
    private static final JobKey JOB_KEY = new JobKey("Plan Deletion Job", "Plan Deletion Service Group");

    public DeletionScheduler(Scheduler quartzScheduler) {
        this.quartzScheduler = quartzScheduler;
    }

    public void initialiseSchedule() {
        try {
            this.scheduleBackgroundPlanDeletion();
            this.scheduleOrphanedResultsDeletion();
        }
        catch (SchedulerException e) {
            log.error((Object)"Unable to schedule Plan Deletion Job", (Throwable)e);
        }
    }

    private void scheduleBackgroundPlanDeletion() throws SchedulerException {
        Trigger trigger = this.quartzScheduler.getTrigger(TRIGGER_KEY);
        if (trigger != null && trigger.mayFireAgain()) {
            return;
        }
        JobDetail jobDetail = JobBuilder.newJob(DeletionServiceJob.class).withIdentity(JOB_KEY).build();
        Trigger trigger2 = TriggerBuilder.newTrigger().withIdentity("deletionServiceTrigger").withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatSecondlyForever((int)120)).build();
        this.quartzScheduler.scheduleJob(jobDetail, trigger2);
        log.info((Object)"Plan Deletion Job running every 120 seconds.");
    }

    private void scheduleOrphanedResultsDeletion() throws SchedulerException {
        Trigger trigger = this.quartzScheduler.getTrigger(ORPHANED_TRIGGER_KEY);
        if (trigger != null && trigger.mayFireAgain()) {
            return;
        }
        JobDetail jobDetail = JobBuilder.newJob(OrphanedBuildResultRemovalJob.class).withIdentity(ORPHANED_JOB_KEY).build();
        Trigger trigger2 = TriggerBuilder.newTrigger().withIdentity("deletionServiceOrphanedResultsTrigger").withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatSecondlyForever((int)86400)).build();
        this.quartzScheduler.scheduleJob(jobDetail, trigger2);
        log.info((Object)"Orphaned Result Deletion Job running every 86400 seconds.");
    }
}

