/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.deletion;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.artifact.ArtifactDao;
import com.atlassian.bamboo.artifact.MutableArtifact;
import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.build.BuildSuspensionCheckBean;
import com.atlassian.bamboo.build.Buildable;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.build.PlanBranchPullRequestService;
import com.atlassian.bamboo.build.PlanDependencyManager;
import com.atlassian.bamboo.build.artifact.ArtifactManager;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentService;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentServiceHelper;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainStageDao;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.deletion.DeletionServiceImpl;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.deployments.versions.service.DeploymentVersionService;
import com.atlassian.bamboo.event.BackgroundDeletionCompletedEvent;
import com.atlassian.bamboo.event.DeletionFinishedEvent;
import com.atlassian.bamboo.event.agent.AgentAssignmentsUpdatedEvent;
import com.atlassian.bamboo.fileserver.SystemDirectory;
import com.atlassian.bamboo.index.BuildResultsIndexer;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueUtils;
import com.atlassian.bamboo.logger.AdminErrorHandler;
import com.atlassian.bamboo.logger.ErrorHandler;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.PlanParticleManager;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionManager;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionHistoryService;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.schedule.PlanScheduler;
import com.atlassian.bamboo.security.acegi.acls.HibernateObjectIdentityImpl;
import com.atlassian.bamboo.storage.StorageLocationService;
import com.atlassian.bamboo.util.AcquisitionPolicy;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaPersister;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.acegisecurity.acls.MutableAclService;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DeletionServiceHelper {
    private static final Logger log = Logger.getLogger(DeletionServiceHelper.class);
    @Inject
    private ErrorHandler errorHandler;
    @Inject
    private BuildResultsIndexer buildResultsIndexer;
    @Inject
    private PlanDependencyManager planDependencyManager;
    @Inject
    private PlanParticleManager planParticleManager;
    @Inject
    private BuildSuspensionCheckBean buildSuspensionCheckBean;
    @Inject
    private AdminErrorHandler adminErrorHandler;
    @Inject
    private MutableAclService aclService;
    @Inject
    private BandanaPersister bandanaPersister;
    @Inject
    private ArtifactManager artifactManager;
    @Inject
    private VariableDefinitionManager variableDefinitionManager;
    @Inject
    private RepositoryDefinitionManager repositoryDefinitionManager;
    @Inject
    private PlanVcsRevisionHistoryService planVcsRevisionHistoryService;
    @Inject
    private VcsBranchManager vcsBranchManager;
    @Inject
    private ArtifactDao artifactDao;
    @Inject
    private DeploymentProjectService deploymentProjectService;
    @Inject
    private DeploymentVersionService deploymentVersionService;
    @Inject
    private PlanBranchPullRequestService planBranchPullRequestService;
    @Inject
    private StorageLocationService storageLocationService;
    @Inject
    private PlanManager planManager;
    @Inject
    private ChainStageDao chainStageDao;
    @Inject
    private ProjectManager projectManager;
    @Inject
    private EventPublisher eventPublisher;
    @Inject
    private ResultsSummaryManager resultsSummaryManager;
    @Inject
    private PlanScheduler planScheduler;
    @Inject
    private AuditLogService auditLogService;
    @Inject
    private AgentAssignmentService agentAssignmentService;
    @Inject
    private ArtifactDefinitionManager artifactDefinitionManager;
    @Inject
    private ArtifactSubscriptionManager artifactSubscriptionManager;
    @Inject
    private ImmutablePlanCacheService immutablePlanCacheService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeDelayedDeletion(ReadWriteLock deletionLock, AcquisitionPolicy acquisitionPolicy) {
        if (!acquisitionPolicy.acquire(deletionLock.writeLock())) {
            return;
        }
        if (!SystemProperty.BAMBOO_DELETION_ENABLED.getValue(true)) {
            log.warn((Object)"Deletion has been disabled using the `-Dbamboo.deletion.enabled=false` flag");
            return;
        }
        log.debug((Object)"Starting background deletion");
        Stopwatch stopWatch = Stopwatch.createStarted();
        boolean hasSomethingBeenDeleted = false;
        String previousThreadName = Thread.currentThread().getName();
        try {
            this.enterDeletionCodeSection();
            hasSomethingBeenDeleted = this.executeDelayedDeletionInternal();
        }
        catch (Exception e) {
            log.error((Object)"Unable to complete delayed deletion: ", (Throwable)e);
        }
        finally {
            this.leaveDeletionCodeSection(previousThreadName);
            deletionLock.writeLock().unlock();
            if (hasSomethingBeenDeleted) {
                log.info((Object)("Completed background deletion in " + stopWatch));
                this.eventPublisher.publish((Object)new DeletionFinishedEvent());
            } else {
                log.debug((Object)"Background deletion completed. Nothing found to delete");
                this.eventPublisher.publish((Object)new BackgroundDeletionCompletedEvent());
            }
        }
    }

    private void enterDeletionCodeSection() {
        Thread.currentThread().setName("DelayedDeletionThread");
        this.immutablePlanCacheService.enterDeletionCodeSection();
    }

    private void leaveDeletionCodeSection(String previousThreadName) {
        this.immutablePlanCacheService.leaveDeletionCodeSection();
        Thread.currentThread().setName(previousThreadName);
    }

    private boolean executeDelayedDeletionInternal() throws Exception {
        this.planManager.syncDeletionStatusOfChainBranches();
        this.planManager.syncDeletionStatusOfJobs();
        Collection jobs = this.planBranchesFirst(this.planManager.getAllPlansMarkedForDeletion(Job.class));
        if (!jobs.isEmpty()) {
            log.info((Object)("Deleting " + jobs.size() + " job(s) marked for deletion"));
            int successCount = this.doDeletePlans(jobs);
            return successCount != 0;
        }
        Multimap chainStages = this.chainStageDao.getChainStagesMarkedForDeletion();
        if (!chainStages.isEmpty()) {
            log.info((Object)("Deleting " + chainStages.size() + " stage(s) marked for deletion"));
            for (Map.Entry entry : chainStages.asMap().entrySet()) {
                this.planManager.removeStages((PlanKey)entry.getKey(), (Collection)entry.getValue());
            }
            return true;
        }
        Collection plans = this.planBranchesFirst(this.planManager.getAllPlansMarkedForDeletion(Chain.class));
        if (!plans.isEmpty()) {
            log.info((Object)("Deleting " + plans.size() + " TopLevelPlan(s) and/or ChainBranch(es) marked for deletion"));
            int successCount = this.doDeletePlans(plans);
            this.repositoryDefinitionManager.removeUnusedRepositories();
            return successCount != 0;
        }
        Collection projects = this.projectManager.getAllProjectsMarkedForDeletion();
        if (!projects.isEmpty()) {
            boolean allProjectSuccessfullyRemoved = true;
            log.info((Object)("Deleting " + projects.size() + " Project(s) marked for deletion"));
            for (Project project : projects) {
                try {
                    log.info((Object)("Deleting " + project.getKey()));
                    this.projectManager.deleteProject(project);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    allProjectSuccessfullyRemoved = false;
                }
            }
            return allProjectSuccessfullyRemoved;
        }
        return false;
    }

    private int doDeletePlans(Iterable<? extends Plan> plans) {
        int successCount = 0;
        for (Plan plan : plans) {
            try {
                this.doDeletePlan(plan);
                ++successCount;
            }
            catch (Exception e) {
                log.error((Object)("Error occurred while deleting plan or job: " + plan.getKey() + ", continue removal of other plans"));
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return successCount;
    }

    private void doDeletePlan(Plan plan) throws Exception {
        log.info((Object)("Deleting " + plan.getPlanKey()));
        if (plan instanceof ImmutableChain) {
            PlanKey planKey = plan.getPlanKey();
            this.deploymentProjectService.unlinkDeploymentProjectsRelatedToPlan(planKey);
            this.deploymentVersionService.updatePlanKey(planKey, PlanKeys.asDeletedPlanKey((PlanKey)planKey));
        }
        for (MutableArtifact mutableArtifact : this.artifactDao.findPlanArtifactsReferencedByVersion(plan.getPlanKey())) {
            this.artifactManager.moveArtifactToGlobalStorage((Artifact)mutableArtifact);
        }
        List affectedJobKeys = plan instanceof ImmutableChain ? this.resultsSummaryManager.findJobKeysFromExistingChainResults(plan.getPlanKey()) : Collections.emptyList();
        this.tearDownPlan(plan);
        if (plan instanceof ImmutableChain) {
            this.artifactManager.removeArtifactsFromStorage(plan.getPlanKey());
            for (PlanKey planKey : affectedJobKeys) {
                this.artifactManager.removeArtifactsFromStorage(planKey);
            }
        }
        this.planManager.deletePlan(plan);
    }

    private void tearDownPlan(@NotNull Plan plan) throws Exception {
        block165: {
            try (Ticker ignored = Timers.start((String)String.format("DeletionServiceImpl.removePlan(%s)", plan.getKey()));){
                Ticker ignored1;
                Throwable throwable;
                List affectedJobKeys;
                List list = affectedJobKeys = plan instanceof ImmutableChain ? this.resultsSummaryManager.findJobKeysFromExistingChainResults(plan.getPlanKey()) : Collections.emptyList();
                if (plan instanceof ImmutableChain) {
                    throwable = null;
                    try (Ticker ignored2 = Timers.start((String)"Remove result summaries");){
                        this.resultsSummaryManager.removeResultsSummariesForPlan(plan);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    this.deIndexBuild(plan.getPlanKey());
                    for (PlanKey planKey : affectedJobKeys) {
                        this.deIndexBuild(planKey);
                    }
                }
                this.errorHandler.removeBuildErrors(plan.getKey());
                this.auditLogService.removeAuditLogMessagesForPlan((ImmutablePlan)plan);
                if (plan instanceof Buildable) {
                    DeletionServiceImpl.removeAssociatedArtifacts((ImmutablePlan)plan, this.artifactDefinitionManager, this.artifactSubscriptionManager);
                }
                if (plan instanceof TopLevelPlan) {
                    ignored1 = Timers.start((String)"TopLevelPlan specific");
                    throwable = null;
                    try {
                        this.planScheduler.removeTasksScheduledForPlanAndBranches((ImmutablePlan)plan);
                        Chain chain = (Chain)Narrow.downTo((Object)plan, Chain.class);
                        if (chain != null && !(chain instanceof ChainBranch)) {
                            this.vcsBranchManager.deleteAll((ImmutableChain)chain);
                        }
                    }
                    catch (Throwable chain) {
                        throwable = chain;
                        throw chain;
                    }
                    finally {
                        if (ignored1 != null) {
                            if (throwable != null) {
                                try {
                                    ignored1.close();
                                }
                                catch (Throwable chain) {
                                    throwable.addSuppressed(chain);
                                }
                            } else {
                                ignored1.close();
                            }
                        }
                    }
                }
                ignored1 = Timers.start((String)"Remove plan particles and dependencies");
                throwable = null;
                try {
                    this.planDependencyManager.removeAllDependenciesForPlan((PlanIdentifier)plan);
                    this.planParticleManager.removePlanParticles(plan.getPlanKey());
                }
                catch (Throwable chain) {
                    throwable = chain;
                    throw chain;
                }
                finally {
                    if (ignored1 != null) {
                        if (throwable != null) {
                            try {
                                ignored1.close();
                            }
                            catch (Throwable chain) {
                                throwable.addSuppressed(chain);
                            }
                        } else {
                            ignored1.close();
                        }
                    }
                }
                ignored1 = Timers.start((String)"Remove plan variables");
                throwable = null;
                try {
                    this.variableDefinitionManager.deleteVariablesForPlan(plan);
                }
                catch (Throwable chain) {
                    throwable = chain;
                    throw chain;
                }
                finally {
                    if (ignored1 != null) {
                        if (throwable != null) {
                            try {
                                ignored1.close();
                            }
                            catch (Throwable chain) {
                                throwable.addSuppressed(chain);
                            }
                        } else {
                            ignored1.close();
                        }
                    }
                }
                ignored1 = Timers.start((String)"Remove repositories and plan vcs history");
                throwable = null;
                try {
                    this.planVcsRevisionHistoryService.clearRevisionHistoryForPlan(plan.getPlanKey());
                    this.repositoryDefinitionManager.removeRepositoriesForPlan(plan);
                }
                catch (Throwable chain) {
                    throwable = chain;
                    throw chain;
                }
                finally {
                    if (ignored1 != null) {
                        if (throwable != null) {
                            try {
                                ignored1.close();
                            }
                            catch (Throwable chain) {
                                throwable.addSuppressed(chain);
                            }
                        } else {
                            ignored1.close();
                        }
                    }
                }
                if (plan instanceof TopLevelPlan) {
                    ignored1 = Timers.start((String)"Remove the ACL");
                    throwable = null;
                    try {
                        this.aclService.deleteAcl((ObjectIdentity)new HibernateObjectIdentityImpl(plan), false);
                    }
                    catch (Throwable chain) {
                        throwable = chain;
                        throw chain;
                    }
                    finally {
                        if (ignored1 != null) {
                            if (throwable != null) {
                                try {
                                    ignored1.close();
                                }
                                catch (Throwable chain) {
                                    throwable.addSuppressed(chain);
                                }
                            } else {
                                ignored1.close();
                            }
                        }
                    }
                }
                ignored1 = Timers.start((String)"Remove Bandana Data");
                throwable = null;
                try {
                    PlanAwareBandanaContext planContext = PlanAwareBandanaContext.forPlan((ImmutablePlan)plan);
                    this.bandanaPersister.remove((BandanaContext)planContext);
                }
                catch (Throwable planContext) {
                    throwable = planContext;
                    throw planContext;
                }
                finally {
                    if (ignored1 != null) {
                        if (throwable != null) {
                            try {
                                ignored1.close();
                            }
                            catch (Throwable planContext) {
                                throwable.addSuppressed(planContext);
                            }
                        } else {
                            ignored1.close();
                        }
                    }
                }
                ignored1 = Timers.start((String)"Remove agent assignments");
                throwable = null;
                try {
                    Set agentAssignmentExecutors = this.agentAssignmentService.getAgentAssignments().forExecutables(AgentAssignmentServiceHelper.asExecutables((ImmutablePlan)plan));
                    if (!agentAssignmentExecutors.isEmpty()) {
                        this.agentAssignmentService.deleteExecutorAssignments((Iterable)agentAssignmentExecutors);
                        this.eventPublisher.publish((Object)new AgentAssignmentsUpdatedEvent(this));
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (ignored1 != null) {
                        if (throwable != null) {
                            try {
                                ignored1.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            ignored1.close();
                        }
                    }
                }
                if (plan instanceof Buildable) {
                    ignored1 = Timers.start((String)"delete Buildable");
                    throwable = null;
                    try {
                        if (!this.buildSuspensionCheckBean.isSuspended()) {
                            this.adminErrorHandler.removeError("buildingSuspendedError");
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (ignored1 != null) {
                            if (throwable != null) {
                                try {
                                    ignored1.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                ignored1.close();
                            }
                        }
                    }
                }
                if (plan instanceof ImmutableChain) {
                    ignored1 = Timers.start((String)"delete Buildable");
                    throwable = null;
                    try {
                        this.deleteRelatedDirectories(plan.getPlanKey());
                        for (PlanKey planKey : affectedJobKeys) {
                            this.deleteRelatedDirectories(planKey);
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable = throwable7;
                        throw throwable7;
                    }
                    finally {
                        if (ignored1 != null) {
                            if (throwable != null) {
                                try {
                                    ignored1.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable.addSuppressed(throwable8);
                                }
                            } else {
                                ignored1.close();
                            }
                        }
                    }
                }
                if (!(plan instanceof ChainBranch)) break block165;
                ignored1 = Timers.start((String)"Remove chain branch pull request connection");
                throwable = null;
                try {
                    this.planBranchPullRequestService.deleteForChainBranch(plan.getId());
                }
                catch (Throwable throwable9) {
                    throwable = throwable9;
                    throw throwable9;
                }
                finally {
                    if (ignored1 != null) {
                        if (throwable != null) {
                            try {
                                ignored1.close();
                            }
                            catch (Throwable throwable10) {
                                throwable.addSuppressed(throwable10);
                            }
                        } else {
                            ignored1.close();
                        }
                    }
                }
            }
        }
    }

    private void deIndexBuild(PlanKey planKey) throws Exception {
        Set jiraIssuesKeys = this.resultsSummaryManager.findJiraIssuesForPlanKey(planKey).stream().map(arg_0 -> JiraIssueUtils.transformJiraIssueToJiraIssueKey().apply(arg_0)).collect(Collectors.toSet());
        try (Ticker ignored = Timers.start((String)String.format("De-indexing build \"%s\"", planKey));){
            try {
                this.buildResultsIndexer.deIndexBuild(planKey, jiraIssuesKeys);
            }
            catch (Exception e) {
                log.warn((Object)("Error de-indexing documents related to build " + planKey + " + during build deletion process. Ignoring..."), (Throwable)e);
            }
        }
    }

    private void deleteRelatedDirectories(PlanKey planKey) {
        try (Ticker ignored = Timers.start((String)"DeletionServiceImpl.clearBuildDirectories()");){
            this.deleteAllPossibleBuildDirectories(planKey);
            BambooFileUtils.deleteQuietly(this.storageLocationService.getBuildDownloadDataDirectory((Key)planKey));
            BambooFileUtils.deleteQuietly(this.storageLocationService.getBuildDataDirectory((Key)planKey));
            if (PlanKeys.isChainKey((PlanKey)planKey)) {
                BambooFileUtils.deleteQuietly(this.storageLocationService.getDefaultArtifactDirectoryBuilder().getChainDirectory(planKey));
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to delete some build directories for " + planKey + ". These will need to be removed manually."));
        }
    }

    private void deleteAllPossibleBuildDirectories(PlanKey planKey) {
        File rootBuildWorkingDirectory = SystemDirectory.getBaseBuildWorkingDirectory();
        String planDir = planKey.toString();
        BambooFileUtils.deleteQuietly(new File(rootBuildWorkingDirectory, planDir));
        File[] subDirectories = rootBuildWorkingDirectory.listFiles();
        if (subDirectories != null) {
            for (File subDir : subDirectories) {
                BambooFileUtils.deleteQuietly(new File(subDir, planDir));
            }
        }
    }

    private <T extends Plan> Collection<T> planBranchesFirst(Collection<T> entities) {
        return BranchesFirstOrdering.forPlans().sortedCopy(entities);
    }

    private static class BranchesFirstOrdering<T>
    extends Ordering<T> {
        private BranchesFirstOrdering() {
        }

        public int compare(T lhs, T rhs) {
            return this.hasMasterInt(lhs) - this.hasMasterInt(rhs);
        }

        private int hasMasterInt(T object) {
            return this.hasMaster(object) ? 0 : 1;
        }

        private boolean hasMaster(T object) {
            ImmutablePlan plan = (ImmutablePlan)Narrow.reinterpret(object, ImmutablePlan.class);
            if (plan != null) {
                return plan.hasMaster();
            }
            return ((ImmutableChainStage)object).hasMaster();
        }

        public static BranchesFirstOrdering<Plan> forPlans() {
            return new BranchesFirstOrdering<Plan>();
        }
    }
}

