/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.deletion;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.StopBuildManager;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentService;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentServiceHelper;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.chains.ChainStageDao;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.deletion.DeletionService;
import com.atlassian.bamboo.deletion.DeletionServiceHelper;
import com.atlassian.bamboo.deletion.PlanDeletionInterceptorAction;
import com.atlassian.bamboo.event.BuildDeletedEvent;
import com.atlassian.bamboo.event.ChainDeletedEvent;
import com.atlassian.bamboo.event.DeletionFinishedEvent;
import com.atlassian.bamboo.event.MultipleChainsDeletedEvent;
import com.atlassian.bamboo.event.MultipleJobsDeletedEvent;
import com.atlassian.bamboo.event.agent.AgentAssignmentsUpdatedEvent;
import com.atlassian.bamboo.persister.AuditLogEntity;
import com.atlassian.bamboo.persister.AuditLogEntityType;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.plugin.descriptor.PlanDeletionInterceptorActionModuleDescriptor;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectConfigurationService;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.schedule.PlanScheduler;
import com.atlassian.bamboo.util.AcquisitionPolicy;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.annotation.Lazy;

public class DeletionServiceImpl
implements DeletionService {
    private static final Logger log = Logger.getLogger(DeletionServiceImpl.class);
    private final ReadWriteLock deletionLock = new ReentrantReadWriteLock();
    private final ReadWriteLock orphanedBuildResultsDeletionLock = new ReentrantReadWriteLock();
    private final PlanScheduler planScheduler;
    private final EventPublisher eventPublisher;
    private final ResultsSummaryManager resultsSummaryManager;
    private final ProjectManager projectManager;
    private final PlanManager planManager;
    private final ChainStageDao chainStageDao;
    private final PluginAccessor pluginAccessor;
    private final ArtifactDefinitionManager artifactDefinitionManager;
    private final ArtifactSubscriptionManager artifactSubscriptionManager;
    private final AuditLogService auditLogService;
    private final StopBuildManager stopBuildManager;
    private final AgentAssignmentService agentAssignmentService;
    @VisibleForTesting
    final DeletionServiceHelper deletionHelper = new DeletionServiceHelper();
    @Inject
    private AutowireCapableBeanFactory beanFactory;
    @Inject
    private ImmutablePlanCacheService immutablePlanCacheService;
    @Inject
    private CachedPlanManager cachedPlanManager;
    @Lazy
    @Inject
    private ProjectConfigurationService projectConfigurationService;

    public DeletionServiceImpl(PlanScheduler planScheduler, EventPublisher eventPublisher, ResultsSummaryManager resultsSummaryManager, ProjectManager projectManager, PlanManager planManager, ChainStageDao chainStageDao, PluginAccessor pluginAccessor, ArtifactDefinitionManager artifactDefinitionManager, ArtifactSubscriptionManager artifactSubscriptionManager, AuditLogService auditLogService, StopBuildManager stopBuildManager, AgentAssignmentService agentAssignmentService) {
        this.planScheduler = planScheduler;
        this.eventPublisher = eventPublisher;
        this.resultsSummaryManager = resultsSummaryManager;
        this.projectManager = projectManager;
        this.planManager = planManager;
        this.chainStageDao = chainStageDao;
        this.pluginAccessor = pluginAccessor;
        this.artifactDefinitionManager = artifactDefinitionManager;
        this.artifactSubscriptionManager = artifactSubscriptionManager;
        this.auditLogService = auditLogService;
        this.stopBuildManager = stopBuildManager;
        this.agentAssignmentService = agentAssignmentService;
    }

    @PostConstruct
    private void postConstruct() {
        this.beanFactory.autowireBean((Object)this.deletionHelper);
    }

    public Set<PlanKey> deleteProjects(Iterable<String> projectKeys) {
        DelayedEventInfo delayedEventInfo = new DelayedEventInfo();
        for (String projectKey : projectKeys) {
            log.info((Object)("Deleting project " + projectKey));
            Project project = (Project)Preconditions.checkNotNull((Object)this.projectManager.getProjectByKey(projectKey), (Object)("Project " + projectKey + " no found. May have already been deleted"));
            Set agentAssignmentExecutors = this.agentAssignmentService.getAgentAssignments().forExecutables(AgentAssignmentServiceHelper.projectToExecutables((Project)project));
            if (!agentAssignmentExecutors.isEmpty()) {
                this.agentAssignmentService.deleteExecutorAssignments((Iterable)agentAssignmentExecutors);
                this.eventPublisher.publish((Object)new AgentAssignmentsUpdatedEvent(this));
            }
            delayedEventInfo.addAll(this.scheduleProjectDeletionNoEvents(project));
        }
        this.fireDelayedEvents(delayedEventInfo);
        return delayedEventInfo.getAllKeys();
    }

    private void fireDelayedEvents(DelayedEventInfo delayedEventInfo) {
        if (!delayedEventInfo.getPlanKeys().isEmpty()) {
            this.eventPublisher.publish((Object)new MultipleChainsDeletedEvent(delayedEventInfo.getPlanKeys()));
        }
        if (!delayedEventInfo.getJobKeys().isEmpty()) {
            this.eventPublisher.publish((Object)new MultipleJobsDeletedEvent(delayedEventInfo.getJobKeys()));
        }
    }

    public void deleteProject(@NotNull Project project) {
        DelayedEventInfo delayedEventInfo = this.scheduleProjectDeletionNoEvents(project);
        this.fireDelayedEvents(delayedEventInfo);
    }

    private DelayedEventInfo scheduleProjectDeletionNoEvents(@NotNull Project project) {
        DelayedEventInfo delayedEventInfo = new DelayedEventInfo();
        for (ImmutableTopLevelPlan plan : this.cachedPlanManager.getPlansByProject(project)) {
            delayedEventInfo.addAll(this.schedulePlanDeletion((ImmutablePlan)plan, DeletionService.FireEvent.NO_FIRE, true));
        }
        this.projectConfigurationService.markProjectForDeletion(project);
        return delayedEventInfo;
    }

    public void deletePlan(@NotNull Plan plan) {
        this.schedulePlanDeletion((ImmutablePlan)plan, DeletionService.FireEvent.FIRE, true);
    }

    public void deletePlan(@NotNull ImmutablePlan plan) {
        this.schedulePlanDeletion(plan, DeletionService.FireEvent.FIRE, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePlansIgnoringBranches(Iterable<? extends Plan> plansToDelete) {
        DelayedEventInfo delayedEventInfo = new DelayedEventInfo();
        try {
            for (Plan plan : plansToDelete) {
                delayedEventInfo.addAll(this.schedulePlanDeletion((ImmutablePlan)plan, DeletionService.FireEvent.NO_FIRE, false));
            }
        }
        finally {
            this.fireDelayedEvents(delayedEventInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PlanKey> deletePlans(Iterable<String> planKeys) {
        DelayedEventInfo delayedEventInfo = new DelayedEventInfo();
        try {
            for (String planKey : planKeys) {
                ImmutablePlan plan = this.cachedPlanManager.getPlanByKey(PlanKeys.getPlanKey((String)planKey));
                if (plan == null) {
                    log.info((Object)("Plan " + planKey + " no found. May have already been deleted"));
                    continue;
                }
                log.info((Object)("Deleting plan " + planKey));
                delayedEventInfo.addAll(this.schedulePlanDeletion(plan, DeletionService.FireEvent.NO_FIRE, true));
            }
        }
        finally {
            this.fireDelayedEvents(delayedEventInfo);
        }
        return delayedEventInfo.getAllKeys();
    }

    private DelayedEventInfo schedulePlanDeletion(@NotNull ImmutablePlan plan, DeletionService.FireEvent fireEvent, boolean cascadeToBranches) {
        DelayedEventInfo delayedEventInfo = new DelayedEventInfo();
        PlanKey planKey = plan.getPlanKey();
        ImmutableChain chain = (ImmutableChain)Narrow.to((Object)plan, ImmutableChain.class);
        if (chain != null) {
            this.planScheduler.removeTasksScheduledForPlanAndBranches((ImmutablePlan)chain);
        }
        try {
            log.info((Object)("Stopping any running builds for " + planKey));
            this.stopBuildManager.cancelAllBuilds(planKey, true);
        }
        catch (InterruptedException e) {
            log.info((Object)"Stopping threw an exception, ignore since deleting anyway");
        }
        log.info((Object)("Scheduling plan [" + planKey + "] for deletion"));
        if (chain != null) {
            this.scheduleChainDeletion(chain, fireEvent, cascadeToBranches, delayedEventInfo, planKey, chain.getId());
        } else {
            ImmutableJob job = (ImmutableJob)Preconditions.checkNotNull((Object)Narrow.to((Object)plan, ImmutableJob.class), (Object)("Unknown plan type " + plan.getClass()));
            this.scheduleJobDeletion(job, fireEvent, cascadeToBranches, delayedEventInfo);
        }
        return delayedEventInfo;
    }

    private void scheduleJobDeletion(@NotNull ImmutableJob job, DeletionService.FireEvent fireEvent, boolean cascadeToBranches, DelayedEventInfo delayedEventInfo) {
        if (cascadeToBranches && !job.hasMaster()) {
            PlanHelper.getBranchesForJob(this.cachedPlanManager, job).forEach(branchedJob -> delayedEventInfo.addAll(this.schedulePlanDeletion((ImmutablePlan)branchedJob, fireEvent, false)));
        }
        DeletionServiceImpl.removeAssociatedArtifacts((ImmutablePlan)job, this.artifactDefinitionManager, this.artifactSubscriptionManager);
        this.markForDeletion((ImmutablePlan)job);
        if (fireEvent == DeletionService.FireEvent.FIRE) {
            this.eventPublisher.publish((Object)new BuildDeletedEvent(this, job.getKey(), job.getDatabaseId().orElse(-1L)));
        } else {
            delayedEventInfo.addJob(job.getPlanKey());
        }
        this.auditLogService.log("Job " + job.getBuildName() + " deleted", (Key)job.getParent().getPlanKey(), AuditLogEntityType.PLAN);
    }

    private void scheduleChainDeletion(ImmutableChain chain, DeletionService.FireEvent fireEvent, boolean cascadeToBranches, DelayedEventInfo delayedEventInfo, PlanKey planKey, long planId) {
        if (cascadeToBranches) {
            this.cachedPlanManager.getBranchesOfChain(chain.getPlanKey()).forEach(branch -> delayedEventInfo.addAll(this.schedulePlanDeletion((ImmutablePlan)branch, fireEvent, false)));
        }
        for (ImmutableChainStage chainStage : chain.getStages()) {
            for (ImmutableJob job : chainStage.getJobs()) {
                try {
                    log.info((Object)("Stopping any running builds for " + job.getPlanKey()));
                    this.stopBuildManager.cancelAllBuilds(job.getPlanKey(), true);
                }
                catch (InterruptedException e) {
                    log.info((Object)"Stopping threw an exception, ignore since deleting anyway");
                }
                DeletionServiceImpl.removeAssociatedArtifacts((ImmutablePlan)job, this.artifactDefinitionManager, this.artifactSubscriptionManager);
                this.markForDeletion((ImmutablePlan)job);
                if (fireEvent == DeletionService.FireEvent.FIRE) {
                    this.eventPublisher.publish((Object)new BuildDeletedEvent(this, job.getKey(), job.getDatabaseId().orElse(-1L)));
                    continue;
                }
                delayedEventInfo.addJob(job.getPlanKey());
            }
            this.chainStageDao.markForDeletion(chainStage);
        }
        delayedEventInfo.addPlan(planKey);
        this.markForDeletion((ImmutablePlan)chain);
        if (fireEvent == DeletionService.FireEvent.FIRE) {
            this.eventPublisher.publish((Object)new ChainDeletedEvent(this, planKey, planId));
        } else {
            delayedEventInfo.addPlan(planKey);
        }
        this.auditLogService.log("Plan deleted: " + chain.getName() + " (" + chain.getKey() + ")");
    }

    private void deleteStageBranches(ImmutableChainStage masterStage) {
        if (masterStage.hasMaster()) {
            return;
        }
        this.cachedPlanManager.getBranchesOfChain(masterStage.getChain().getPlanKey()).forEach(branch -> {
            ImmutableChainStage branchedStage = PlanHelper.getBranchedStage((ImmutableChain)branch, masterStage);
            this.deleteStage(branchedStage);
        });
    }

    public void deleteStagesIgnoringBranchesAndJobs(Iterable<ChainStage> stagesToDelete) {
        for (ChainStage chainStage : stagesToDelete) {
            chainStage.setMarkedForDeletion(true);
            this.chainStageDao.save((BambooObject)chainStage);
            this.auditLogService.log("Stage has been removed.", (Key)chainStage.getChain().getPlanKey(), AuditLogEntityType.PLAN, new AuditLogEntity(AuditLogEntityType.STAGE, chainStage.getName()));
        }
    }

    public void deleteStage(@NotNull ChainStage chainStage) {
        this.deleteStage((ImmutableChainStage)chainStage);
    }

    public void deleteStage(@NotNull ImmutableChainStage chainStage) {
        log.info((Object)("Scheduling stage [" + chainStage.getChain().getPlanKey() + "::" + chainStage.getName() + "] for deletion"));
        for (ImmutableJob job : chainStage.getJobs()) {
            this.deletePlan((ImmutablePlan)job);
        }
        this.deleteStageBranches(chainStage);
        if (chainStage.getDatabaseId().isPresent()) {
            this.immutablePlanCacheService.hideDeletedStage(Long.valueOf(chainStage.getId()));
        }
        this.chainStageDao.markForDeletion(chainStage);
        this.auditLogService.log("Stage has been removed.", (Key)chainStage.getChain().getPlanKey(), AuditLogEntityType.PLAN, new AuditLogEntity(AuditLogEntityType.STAGE, chainStage.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOrphanedBuildResults() {
        if (!this.orphanedBuildResultsDeletionLock.writeLock().tryLock()) {
            log.warn((Object)"Unable to acquire lock for orphaned build results deletion");
            return;
        }
        try {
            this.deletionLock.writeLock().lock();
            log.info((Object)"Starting background deletion of orphaned build results");
            Stopwatch stopWatch = Stopwatch.createStarted();
            try {
                int orphanCount = this.resultsSummaryManager.removeAllOrphanedResultSummaries();
                if (orphanCount > 0) {
                    log.info((Object)("Deleted " + orphanCount + " orphaned results"));
                }
            }
            catch (Exception e) {
                log.error((Object)"Unable to complete deletion of orphaned build results: ", (Throwable)e);
            }
            finally {
                this.deletionLock.writeLock().unlock();
                this.eventPublisher.publish((Object)new DeletionFinishedEvent());
                log.info((Object)("Completed background deletion of orphaned build results in " + stopWatch));
            }
        }
        finally {
            this.orphanedBuildResultsDeletionLock.writeLock().unlock();
        }
    }

    public void executeDelayedDeletion() {
        this.deletionHelper.executeDelayedDeletion(this.deletionLock, AcquisitionPolicy.IMMEDIATE);
    }

    public void executeDelayedDeletionBlocking() {
        this.deletionHelper.executeDelayedDeletion(this.deletionLock, AcquisitionPolicy.WAIT);
    }

    public void suspendDeletions() {
        this.deletionLock.readLock().lock();
    }

    public boolean suspendDeletions(long secondsToWait) {
        try {
            return this.deletionLock.readLock().tryLock(secondsToWait, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public void resumeDeletions() {
        this.deletionLock.readLock().unlock();
    }

    private void markForDeletion(@NotNull ImmutablePlan plan) {
        PlanKey planKey = plan.getPlanKey();
        if (!(plan instanceof ImmutableJob)) {
            this.resultsSummaryManager.markResultSummariesForDeletion(planKey);
        }
        this.planManager.markPlansForDeletion(planKey);
        this.immutablePlanCacheService.hideDeletedPlan(planKey);
        this.runDeletionInterceptors(plan);
    }

    private void runDeletionInterceptors(ImmutablePlan plan) {
        List interceptorActions = this.pluginAccessor.getEnabledModuleDescriptorsByClass(PlanDeletionInterceptorActionModuleDescriptor.class);
        for (PlanDeletionInterceptorActionModuleDescriptor descriptor : interceptorActions) {
            try {
                PlanDeletionInterceptorAction action = (PlanDeletionInterceptorAction)descriptor.getModule();
                action.intercept(plan, () -> this.planManager.getPlanByKey(plan.getPlanKey()));
            }
            catch (Throwable e) {
                log.error((Object)("Error running '" + descriptor.getModuleClass().getName() + "'. The execution of this interceptor has been skipped."), e);
            }
        }
    }

    static void removeAssociatedArtifacts(@NotNull ImmutablePlan plan, ArtifactDefinitionManager artifactDefinitionManager, ArtifactSubscriptionManager artifactSubscriptionManager) {
        artifactDefinitionManager.removeArtifactDefinitionsByPlan(plan);
        artifactSubscriptionManager.removeArtifactSubscriptionsOfPlan(plan);
    }

    static class DelayedEventInfo {
        private final Set<PlanKey> planKeys = new TreeSet<PlanKey>();
        private final Set<PlanKey> jobKeys = new TreeSet<PlanKey>();

        DelayedEventInfo() {
        }

        Set<PlanKey> getJobKeys() {
            return this.jobKeys;
        }

        public Set<PlanKey> getPlanKeys() {
            return this.planKeys;
        }

        public void addAll(DelayedEventInfo delayedEventInfo) {
            this.jobKeys.addAll(delayedEventInfo.getJobKeys());
            this.planKeys.addAll(delayedEventInfo.getPlanKeys());
        }

        void addPlan(PlanKey planKey) {
            this.planKeys.add(planKey);
        }

        public void addJob(PlanKey jobKey) {
            this.jobKeys.add(jobKey);
        }

        Set<PlanKey> getAllKeys() {
            return Sets.union(this.jobKeys, this.planKeys);
        }
    }
}

