/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.deletion;

import com.atlassian.bamboo.build.artifact.ArtifactManager;
import com.atlassian.bamboo.deletion.DeletionService;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.variable.baseline.VariableContextBaselineDao;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class OrphanedBuildResultRemovalJob
implements Job {
    private static final Logger log = Logger.getLogger(OrphanedBuildResultRemovalJob.class);
    @Inject
    private DeletionService deletionService;
    @Inject
    private VariableContextBaselineDao variableContextBaselineDao;
    @Inject
    private ArtifactManager artifactManager;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        if (SystemProperty.BAMBOO_DELETION_ENABLED.getValue(true)) {
            log.warn((Object)"Deletion can be disabled with a command line switch.");
            this.deletionService.removeOrphanedBuildResults();
            this.variableContextBaselineDao.deleteOrphans();
            this.artifactManager.removeOrphanedArtifacts();
        } else {
            log.warn((Object)"Deletion has been disabled using the `-Dbamboo.deletion.enabled=false` flag.");
        }
    }
}

